package com.ximai.mes.cal.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 排班计划对象 cal_plan
 *
 * @date 2022-06-06
 */
@Data
@ApiModel(description = "排班计划实体")
public class CalPlan extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 计划ID
     */
    @ApiModelProperty(value = "计划id")
    private Long planId;

    /**
     * 计划编号
     */
    @ApiModelProperty(value = "计划编号")
    @Excel(name = "计划编号")
    private String planCode;

    /**
     * 计划名称
     */
    @ApiModelProperty(value = "计划名称")
    @Excel(name = "计划名称")
    private String planName;

    private String calendarType;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endDate;

    /**
     * 轮班方式
     */
    @ApiModelProperty(value = "轮班方式 SHIFT_THREE/SHIFT_TWO/SHIFT_ONE")
    @Excel(name = "轮班方式")
    private String shiftType;

    /**
     * 倒班方式
     */
    @Excel(name = "倒班方式")
    private String shiftMethod;

    /**
     * 数
     */
    @Excel(name = "数")
    private Long shiftCount;


    @ApiModelProperty(value = "节假日是否休息 0/1")
    private Integer sunday;

    @ApiModelProperty(value = "节假日是否休息 0/1")
    private Integer saturday;

    @ApiModelProperty(value = "计划状态 PREPARE/CONFIRMED")
    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

    @ApiModelProperty(value = "轮班班次列表")
    private List<CalShift> calShifts;


    @ApiModelProperty(value = "工作单元")
    private List<CalWorkunit> calWorkunits;
}
