package com.ximai.mes.pro.service.prototypeRequest;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessItem;

/**
 * 打样申请工序物料Service接口
 *
 * @author zht
 * @date 2024-01-18
 */
public interface IProPrototypeRequestProcessItemService
{
    /**
     * 查询打样申请工序物料
     *
     * @param prototypeRequestProcessItemId 打样申请工序物料主键
     * @return 打样申请工序物料
     */
    public ProPrototypeRequestProcessItem selectProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(Long prototypeRequestProcessItemId);

    /**
     * 查询打样申请工序物料列表
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 打样申请工序物料集合
     */
    public List<ProPrototypeRequestProcessItem> selectProPrototypeRequestProcessItemList(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem);

    /**
     * 新增打样申请工序物料
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 结果
     */
    public int insertProPrototypeRequestProcessItem(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem);

    /**
     * 修改打样申请工序物料
     *
     * @param proPrototypeRequestProcessItem 打样申请工序物料
     * @return 结果
     */
    public int updateProPrototypeRequestProcessItem(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem);

    /**
     * 批量删除打样申请工序物料
     *
     * @param prototypeRequestProcessItemIds 需要删除的打样申请工序物料主键集合
     * @return 结果
     */
    public int deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemIds(Long[] prototypeRequestProcessItemIds);

    /**
     * 删除打样申请工序物料信息
     *
     * @param prototypeRequestProcessItemId 打样申请工序物料主键
     * @return 结果
     */
    public int deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(Long prototypeRequestProcessItemId);
}
