package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.vo.ProProcessTaskVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import com.ximai.mes.pro.mapper.ProFeedbackMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 生产工单工序Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Service
public class ProWorkOrderProcessServiceImpl implements IProWorkOrderProcessService {
    @Autowired
    private ProWorkOrderProcessMapper proWorkOrderProcessMapper;

    @Autowired
    private ProWorkorderMapper proWorkorderMapper;


    @Autowired
    private ProFeedbackMapper proFeedbackMapper;

    /**
     * 查询生产工单工序
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 生产工单工序
     */
    @Override
    public ProWorkOrderProcessVo selectProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId) {
        return proWorkOrderProcessMapper.selectProWorkOrderProcessByWorkorderProcessId(workorderProcessId);
    }

    /**
     * 查询生产工单工序列表
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 生产工单工序
     */
    @Override
    public List<ProWorkOrderProcessVo> selectProWorkOrderProcessList(ProWorkOrderProcess proWorkOrderProcess) {
        return proWorkOrderProcessMapper.selectProWorkOrderProcessList(proWorkOrderProcess);
    }

    @Override
    public List<ProWorkOrderProcess> selectListByQw(QueryWrapper<ProWorkOrderProcess> query) {
        return proWorkOrderProcessMapper.selectListByQw(query);
    }

    /**
     * 新增生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    @Override
    public int insertProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess) {
        proWorkOrderProcess.createAction();
        return proWorkOrderProcessMapper.insertProWorkOrderProcess(proWorkOrderProcess);
    }

    /**
     * 修改生产工单工序
     *
     * @param proWorkOrderProcess 生产工单工序
     * @return 结果
     */
    @Override
    public int updateProWorkOrderProcess(ProWorkOrderProcess proWorkOrderProcess) {
        proWorkOrderProcess.updateAction();
        return proWorkOrderProcessMapper.updateProWorkOrderProcess(proWorkOrderProcess);
    }


    /**
     * 批量删除生产工单工序
     *
     * @param workorderProcessIds 需要删除的生产工单工序主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessByWorkorderProcessIds(Long[] workorderProcessIds) {
        return proWorkOrderProcessMapper.deleteProWorkOrderProcessByWorkorderProcessIds(workorderProcessIds);
    }

    /**
     * 删除生产工单工序信息
     *
     * @param workorderProcessId 生产工单工序主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderProcessByWorkorderProcessId(Long workorderProcessId) {
        return proWorkOrderProcessMapper.deleteProWorkOrderProcessByWorkorderProcessId(workorderProcessId);
    }


    @Override
    public void deleteByWorkorderCode(String workorderCode) {
        QueryWrapper<ProWorkOrderProcess> proWorkOrderProcessQueryWrapper = new QueryWrapper<>();
        proWorkOrderProcessQueryWrapper.eq("workorder_code", workorderCode);
        proWorkOrderProcessMapper.deleteProWorkOrderProcess(proWorkOrderProcessQueryWrapper);
    }

    @Override
    public List<ProProcessTaskVo> selectprocessReportFormList(ProProcessTaskVo proProcessTaskVo) {
        QueryWrapper<ProProcessTaskVo> query = new QueryWrapper<>();
        query.eq(proProcessTaskVo.getWorkorderId() != null, "w.workorder_id", proProcessTaskVo.getWorkorderId());
        List<ProProcessTaskVo> processTaskVo = proWorkorderMapper.selectProWorkorderProcessWorkorderId(query);
        for (ProProcessTaskVo taskVo : processTaskVo) {
            if (StringUtils.isEmpty(taskVo.getQuantity())) {
                taskVo.setQuantity(new BigDecimal(0));
            }
            if (StringUtils.isNotEmpty(taskVo.getStatus())) {
                if (taskVo.getStatus().equals("ERROR_STOP")) {
                    taskVo.setStatus("PREPARE");
                }
                if (taskVo.getStatus().equals("PAUSE")) {
                    taskVo.setStatus("PREPARE");
                }
            } else {

                taskVo.setStatus("PREPARE");
            }
            if (StringUtils.isNotEmpty(taskVo.getTaskId())) {
                ProProcessTaskVo processTask = proFeedbackMapper.selectProFeedbackFeedback(taskVo.getTaskId(), taskVo.getProcessId());
                if (Objects.nonNull(processTask)) {
                    taskVo.setQuantityFeedback(processTask.getQuantityFeedback());
                    taskVo.setQuantityQualify(processTask.getQuantityQualify());
                    taskVo.setQuantityUnqualify(processTask.getQuantityUnqualify());
                    taskVo.setQuantityUncheck(processTask.getQuantityUncheck());
                }
            } else {
                taskVo.setQuantityFeedback(new BigDecimal(0));
                taskVo.setQuantityQualify(new BigDecimal(0));
                taskVo.setQuantityUnqualify(new BigDecimal(0));
                taskVo.setQuantityUncheck(new BigDecimal(0));
            }
        }

        return processTaskVo;
    }
}
