package com.ximai.mes.pro.schedule.strategy;

import cn.hutool.core.util.NumberUtil;
import com.ximai.mes.pro.schedule.IOperationTimeCalculator;
import com.ximai.mes.pro.schedule.TaskSchedulingContext;

import java.time.Duration;
import java.util.List;

/**
 * 班次评估设备
 * NumberUtil.max(10-N,0)，N=更新班次次数
 *
 */
public class EvaluateEquipmentShift implements EvaluateEquipment{

    @Override
    public double evaluate(TaskSchedulingContext context, IOperationTimeCalculator.OperationTimePlan operationTimePlan
            , List<TaskSchedulingContext.TaskSchedulingResultContext> scheduleResult) {
        //切换时间段次数
        int switchShiftCount=0;
        //最少换型
        List<IOperationTimeCalculator.OperationTimePlanItem> operationTimePlanItemList = operationTimePlan.getPlan();
        if(operationTimePlanItemList.isEmpty()){
            return 0;
        }
        //计算切换班次次数
        String tempShiftType = operationTimePlanItemList.get(0).getShiftType();
        Duration tempEndTime = operationTimePlanItemList.get(0).getEndedTime();
        for(int i=1;i<operationTimePlanItemList.size();i++){
            Duration interval = operationTimePlanItemList.get(i).getEndedTime().minus(tempEndTime);
            //跨8小时或切换班次都算为切换班次
            if(operationTimePlanItemList.get(i).getShiftType()!=null&&
                    (!operationTimePlanItemList.get(i).getShiftType().equals(tempShiftType)
                    || interval.toHours()>=8)){
                switchShiftCount++;
                tempShiftType = operationTimePlanItemList.get(i).getShiftType();
            }
        }
        //计算总空闲工时
        //切换斑次次数评分
        return NumberUtil.max(10-switchShiftCount,0);
    }

    @Override
    public int weight() {
        return 1;
    }

}
