package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 反冲料登记对象 pro_recoil_material
 *
 * @author generator
 * @date 2024-02-22
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProRecoilMaterial extends BaseEntity {
    private static final long serialVersionUID = 1L;


    @TableId
    private Long id;

    /**
     * 编号
     */
    private String recoilMaterialCode;

    /**
     * 任务单ID
     */
    @Excel(name = "任务单ID")
    private Long taskId;

    /**
     * 任务单ID
     */
    @Excel(name = "排产单ID")
    private Long taskWorkunitId;


    /**
     * 产品ID
     */
    private Long itemId;

    private String sapItemCode;

    private String itemName;


    private int quantity;

    private int status;
    /**
     * 批次号
     */
    @Excel(name = "批次号")
    private String batchNo;

    /**
     * 卷号
     */
    @Excel(name = "卷号")
    private String packNo;
    @TableField(exist = false)
    private Double requestSum;
    @TableField(exist = false)
    private Long sum;
    @TableField(exist = false)
    private String specification;
    @TableField(exist = false)
    private String itemTypeName;
    @TableField(exist = false)
    private String unitOfMeasure;
    @TableField(exist = false)
    private String statusStr;

    public String getStatusStr() {
        if (this.status == 1) {
            return "已检查";
        }
        return "未检查";
    }

    @TableField(exist = false)
    List<ProRecoilMaterial> proRecoilMaterialList;

}
