package com.ximai.mes.cal.service;

import com.ximai.mes.cal.domain.CalShift;
import com.ximai.mes.cal.domain.vo.CalShiftVo;

import java.util.List;

/**
 * 计划班次Service接口
 *
 * @date 2022-06-06
 */
public interface ICalShiftService {

    /**
     * 查询计划班次
     *
     * @param shiftId 计划班次主键
     * @return 计划班次
     */
    CalShift selectCalShiftByShiftId(Long shiftId);

    /**
     * 查询计划班次列表
     *
     * @param calShift 计划班次
     * @return 计划班次集合
     */
    List<CalShift> selectCalShiftList(CalShift calShift);


    int checkShiftCount(Long planId);


    /**
     * 新增计划班次
     *
     * @param calShift 计划班次
     * @return 结果
     */
    int insertCalShift(CalShift calShift);

    /**
     * 修改计划班次
     *
     * @param calShift
     * @return 结果
     */
    int updateCalShift(CalShift calShift);

    /**
     * 批量删除计划班次
     *
     * @param shiftIds 需要删除的计划班次主键集合
     * @return 结果
     */
    int deleteCalShiftByShiftIds(Long[] shiftIds);

    /**
     * 删除计划班次信息
     *
     * @param shiftId 计划班次主键
     * @return 结果
     */
    int deleteCalShiftByShiftId(Long shiftId);

    int deleteByPlanId(Long planId);

    List<CalShiftVo> getDetailShift(String shiftType);

}
