package com.bs.mes.schedule.strategy;

import com.ximai.mes.pro.schedule.IOperationTimeCalculator;
import com.ximai.mes.pro.schedule.Job;
import com.ximai.mes.pro.schedule.TaskSchedulingContext;
import com.ximai.mes.pro.schedule.strategy.EvaluateEquipmentCapacity;
import org.junit.Assert;
import org.junit.Test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class EvaluateEquipmentCapacityTest {
    @Test public void evaluate(){
        EvaluateEquipmentCapacity evaluateEquipmentCapacity = new EvaluateEquipmentCapacity();
        TaskSchedulingContext context = new TaskSchedulingContext();
        IOperationTimeCalculator.OperationTimePlan operationTimePlan = new IOperationTimeCalculator.OperationTimePlan();
        List<IOperationTimeCalculator.OperationTimePlanItem> operationTimePlanItemList = new ArrayList<IOperationTimeCalculator.OperationTimePlanItem>();
        operationTimePlan.setPlan(operationTimePlanItemList);
        operationTimePlan.setScheduledSuccess(true);
        Job job = new Job("1", Duration.ofMinutes(12));
        job.setProducedDeliveryTime(Duration.ofMinutes(3000));
        context.setJob(job);
        operationTimePlanItemList.add(new IOperationTimeCalculator.OperationTimePlanItem(){{
            setStartedTime(Duration.ofMinutes(2888));
            setEndedTime(Duration.ofMinutes(2900));
        }});
        //产能足
        double rst = evaluateEquipmentCapacity.evaluate(context, operationTimePlan, null);
        Assert.assertEquals(10, rst, Double.valueOf(0.001));
        //产能不足
        operationTimePlan.setScheduledSuccess(false);
        rst = evaluateEquipmentCapacity.evaluate(context, operationTimePlan, null);
        Assert.assertEquals(5.0, rst, Double.valueOf(0.001));

    }
}
