package com.ximai.mes.wm.service;

import java.util.List;
import com.ximai.mes.wm.domain.WmProductRecpt;
import com.ximai.mes.wm.domain.tx.ProductRecptTxBean;

/**
 * 产品入库录Service接口
 *
 * @date 2022-09-22
 */
public interface IWmProductRecptService
{
    /**
     * 查询产品入库录
     *
     * @param recptId 产品入库录主键
     * @return 产品入库录
     */
     WmProductRecpt selectWmProductRecptByRecptId(Long recptId);

    /**
     * 查询产品入库录列表
     *
     * @param wmProductRecpt 产品入库录
     * @return 产品入库录集合
     */
     List<WmProductRecpt> selectWmProductRecptList(WmProductRecpt wmProductRecpt);


    /**
     * 检查编码唯一性
     * @param wmProductRecpt
     * @return
     */
     String checkUnique(WmProductRecpt wmProductRecpt);

    /**
     * 新增产品入库录
     *
     * @param wmProductRecpt 产品入库录
     * @return 结果
     */
     int insertWmProductRecpt(WmProductRecpt wmProductRecpt);

    /**
     * 修改产品入库录
     *
     * @param wmProductRecpt 产品入库录
     * @return 结果
     */
     int updateWmProductRecpt(WmProductRecpt wmProductRecpt);

    /**
     * 批量删除产品入库录
     *
     * @param recptIds 需要删除的产品入库录主键集合
     * @return 结果
     */
     int deleteWmProductRecptByRecptIds(Long[] recptIds);

    /**
     * 删除产品入库录信息
     * 
     * @param recptId 产品入库录主键
     * @return 结果
     */
     int deleteWmProductRecptByRecptId(Long recptId);

     List<ProductRecptTxBean> getTxBean(Long recptId);
}
