package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 工单BOM对象 ProWorkorderBomErpDto
 *
 * @date 2024-10-18
 */
@Data
public class ProWorkorderBomErpDto
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("材料品号")
    @JsonProperty("tb003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String itemCode;

    @ApiModelProperty("材料品名")
    @JsonProperty("tb012")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String itemName;

    @ApiModelProperty("材料规格")
    @JsonProperty("tb013")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String itemSpc;

    @ApiModelProperty("工艺")
    @JsonProperty("tb006")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String opName;

    @ApiModelProperty("需领用量")
    @JsonProperty("tb004")
    private BigDecimal quantity;
}
