package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 物料仓库对象 MdItemWarehouseErpDto
 *
 * @date 2024-10-18
 */
@Data
public class MdItemWarehouseErpDto
{
    private static final long serialVersionUID = 1L;

    @JsonProperty("mc002")
    @ApiModelProperty("仓库编号")
    private String warehouseCode;

    @JsonProperty("mc001")
    @ApiModelProperty("物料编号")
    private String itemCode;

    @JsonProperty("mc004")
    @ApiModelProperty("安全库存")
    private BigDecimal safetyStock;

    @JsonProperty("mc015")
    @ApiModelProperty("库位")
    private String location;

}
