package com.ximai.mes.remote;

import com.ximai.mes.remote.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * erp远程调用接口
 */
@FeignClient(value = "erp-service", url = "${remote.erp.url}")
public interface ErpService {

    /**
     * 查询供应商
     */
    @PostMapping(value = "/purma/getPurmaList")
    ErpResponseResult<List<MdVendorErpDto>> getVendorList(MdVendorErpQuery vendorErpQuery);

    /**
     * 查询客户
     */
    @PostMapping(value = "/copma/getCopmaList")
    ErpResponseResult<List<MdClientErpDto>> getClientList(MdClientErpQuery clientErpQuery);

    /**
     * 查询仓库
     */
    @PostMapping(value = "/cmsmc/getCmsmcList")
    ErpResponseResult<List<WmWarehouseErpDto>> getWarehouseList(WmWarehouseErpQuery warehouseErpQuery);

    /**
     * 查询物料基础数据
     */
    @PostMapping(value = "/invmb/getInvmbList")
    ErpResponseResult<List<MdItemErpDto>> getItemList(MdItemErpQuery itemErpQuery);

    /**
     * 查询工单
     */
    @PostMapping(value = "/mocta/getMoctaList")
    ErpResponseResult<List<ProWorkorderErpDto>> getWorkorderList(ProWorkorderErpQuery workorderErpQuery);

}
