package com.ximai.mes.qc.service.impl;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.constant.QcAbnormalTypeEnum;
import com.ximai.mes.constant.TaskWorkunitStatusEnum;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.service.IMdWorkunitService;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.pro.domain.ProProcess;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.mapper.ProProcessMapper;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.pro.service.IProPauseWorkService;
import com.ximai.mes.pro.service.IProStartWorkService;
import com.ximai.mes.pro.service.task.IProTaskWorkunitService;
import com.ximai.mes.qc.domain.QcAbnormalReport;
import com.ximai.mes.qc.mapper.QcAbnormalReportMapper;
import com.ximai.mes.qc.service.IQcAbnormalReportService;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 车间异常单Service业务层处理
 *
 * @author generator
 * @date 2024-02-20
 */
@Service
public class QcAbnormalReportServiceImpl implements IQcAbnormalReportService {
    @Autowired
    private QcAbnormalReportMapper qcAbnormalReportMapper;

    @Autowired
    private ProTaskMapper proTaskMapper;

    @Autowired
    private IMdWorkunitService iMdWorkunitService;

    @Autowired
    private IProTaskWorkunitService proTaskWorkunitService;

    @Autowired
    private IProPauseWorkService proPauseWorkService;


    @Autowired
    private IProStartWorkService proStartWorkService;

    @Autowired
    private ProProcessMapper proProcessMapper;


    @Autowired
    private AutoCodeUtil autoCodeUtil;
    /**
     * 查询车间异常单
     *
     * @param abnormalReportId 车间异常单主键
     * @return 车间异常单
     */
    @Override
    public QcAbnormalReport selectQcAbnormalReportByAbnormalReportId(Long abnormalReportId) {
        return qcAbnormalReportMapper.selectQcAbnormalReportByAbnormalReportId(abnormalReportId);
    }

    /**
     * 查询车间异常单列表
     *
     * @param qcAbnormalReport 车间异常单
     * @return 车间异常单
     */
    @Override
    public List<QcAbnormalReport> selectQcAbnormalReportList(QcAbnormalReport qcAbnormalReport) {
        return qcAbnormalReportMapper.selectQcAbnormalReportList(qcAbnormalReport);
    }

    /**
     * 新增车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    @Override
    public int insertObj(QcAbnormalReport qcAbnormalReport) {
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunitService.selectProTaskWorkunitByTaskWorkunitId(qcAbnormalReport.getTaskWorkunitId());

        //根据车间异常原因修改工作单元是否故障
        if (qcAbnormalReport.getAbnormalType().equals(QcAbnormalTypeEnum.DEVI.getType())) {
            MdWorkunit mdWorkunit = new MdWorkunit();
            mdWorkunit.setWorkunitName(qcAbnormalReport.getWorkstationName());
            MdWorkunitVo mdWorkunitVo = iMdWorkunitService.selectMdWorkunitByWorkunitId(qcAbnormalReport.getWorkstationId());
            mdWorkunitVo.setFaultFlag("Y");
            MdWorkunit mdWorkunit1 = mdWorkunitVo.deepCopyObj(MdWorkunit.class);
            iMdWorkunitService.updateMdWorkunit(mdWorkunit1);
        }
        if(StringUtils.isEmpty(qcAbnormalReport.getProcessCode())){
            ProProcess proProcess = proProcessMapper.selectProProcessByProcessId(qcAbnormalReport.getProcessId());
            qcAbnormalReport.setProcessCode(proProcess.getProcessCode());
        }
        proStartWorkService.updateObj(qcAbnormalReport);
        proTaskWorkunit.setStatus(TaskWorkunitStatusEnum.ERROR_STOP.getStatus());
        proTaskWorkunitService.updateProTaskWorkunit(proTaskWorkunit);

        //新增异常报告单
        qcAbnormalReport.setAbnormalStatus("NOT");
        qcAbnormalReport.setAbnormalTime(DateUtils.getNowDate());
        return this.insertQcAbnormalReport(qcAbnormalReport);
    }

    /**
     * 新增车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    @Override
    public int insertQcAbnormalReport(QcAbnormalReport qcAbnormalReport) {
        qcAbnormalReport.createAction();
        return qcAbnormalReportMapper.insertQcAbnormalReport(qcAbnormalReport);
    }

    /**
     * 修改车间异常单
     *
     * @param qcAbnormalReport 车间异常单
     * @return 结果
     */
    @Override
    public int updateQcAbnormalReport(QcAbnormalReport qcAbnormalReport) {
        qcAbnormalReport.updateAction();
        return qcAbnormalReportMapper.updateQcAbnormalReport(qcAbnormalReport);
    }

    /**
     * 批量删除车间异常单
     *
     * @param abnormalReportIds 需要删除的车间异常单主键
     * @return 结果
     */
    @Override
    public int deleteQcAbnormalReportByAbnormalReportIds(Long[] abnormalReportIds) {
        return qcAbnormalReportMapper.deleteQcAbnormalReportByAbnormalReportIds(abnormalReportIds);
    }

    /**
     * 删除车间异常单信息
     *
     * @param abnormalReportId 车间异常单主键
     * @return 结果
     */
    @Override
    public int deleteQcAbnormalReportByAbnormalReportId(Long abnormalReportId) {
        return qcAbnormalReportMapper.deleteQcAbnormalReportByAbnormalReportId(abnormalReportId);
    }

    /**
     * 完成或关闭按钮的功能实现
     *
     * @param
     * @return 结果
     */
    @Override
    public void updateQcAbnormalReportAbmornalStatud(QcAbnormalReport qcAbnormalReportInput) {
        QcAbnormalReport qcAbnormalReport = qcAbnormalReportMapper.selectQcAbnormalReportByAbnormalReportId(qcAbnormalReportInput.getAbnormalReportId());
        if (!qcAbnormalReport.getAbnormalStatus().equals("SUBMIT")) {
            throw new ServiceException(MessageUtils.message("车间异常单不处于处理中状态无法完成"));
        }
        //修改关联名称的工作单元的故障状态
        MdWorkunitVo mdWorkunitVo = iMdWorkunitService.selectMdWorkunitByWorkunitId(qcAbnormalReport.getWorkstationId());
        if (mdWorkunitVo.getFaultFlag().equals("Y")) {
            MdWorkunit w = new MdWorkunit();
            mdWorkunitVo.setFaultFlag("N");
            BeanUtils.copyProperties(mdWorkunitVo, w);
            iMdWorkunitService.updateMdWorkunit(w);
        }
        String endBy = SecurityUtils.getUsername();
        qcAbnormalReport.setEndBy(endBy);
        qcAbnormalReport.setEndTime(new Date());
        if(qcAbnormalReport.getStartTime() != null)
            qcAbnormalReport.setTimeConsuming(qcAbnormalReport.getStartTime().getTime() - qcAbnormalReport.getEndTime().getTime());
        qcAbnormalReport.setRemarks(qcAbnormalReportInput.getRemarks());
        qcAbnormalReport.setAbnormalStatus(qcAbnormalReportInput.getAbnormalStatus());
        qcAbnormalReportMapper.updateQcAbnormalReport(qcAbnormalReport);
    }

    @Override
    public String getAbnormalNumber() {
        return autoCodeUtil.genSerialCode("ABNORMAL_NUMBER", null);
    }

    @Override
    public void start(Long abnormalReportIds) {
        QcAbnormalReport qcAbnormalReport = qcAbnormalReportMapper.selectQcAbnormalReportByAbnormalReportId(abnormalReportIds);
        if(qcAbnormalReport == null)
            throw new ServiceException(MessageUtils.message("没能根据单据ID找到车间异常单"));
        if (!qcAbnormalReport.getAbnormalStatus().equals("NOT")) {
            throw new ServiceException(MessageUtils.message("车间异常单不处于未提交状态无法开始"));
        }
        String startBy = SecurityUtils.getUsername();
        qcAbnormalReport.setStartBy(startBy);
        qcAbnormalReport.setStartTime(new Date());
        qcAbnormalReport.setAbnormalStatus("SUBMIT");
        qcAbnormalReportMapper.updateQcAbnormalReport(qcAbnormalReport);
    }

}
