package com.ximai.mes.pro.service.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.domain.vo.task.ProTaskWorkunitQuery;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitOutsourceSplitParam;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitToOutsourceParam;
import com.ximai.mes.pro.domain.vo.task.TaskWorkunitToSelfMadeParam;
import org.apache.ibatis.annotations.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 任务工作单元Service接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface IProTaskWorkunitService {
    /**
     * 查询任务工作单元
     *
     * @param taskWorkunitId 任务工作单元主键
     * @return 任务工作单元
     */
    ProTaskWorkunit selectProTaskWorkunitByTaskWorkunitId(Long taskWorkunitId);

    ProTaskWorkunit selectMainObjById(Long taskWorkunitId);

    /**
     * 查询任务工作单元列表
     *
     * @param proTaskWorkunit 任务工作单元
     * @return 任务工作单元集合
     */
    List<ProTaskWorkunit> selectProTaskWorkunitList(ProTaskWorkunit proTaskWorkunit);

    /**
     * 查询任务工作单元列表
     *
     * @param query
     * @return 任务工作单元集合
     */
    List<ProTaskWorkunit> selectTaskWorkUnitJoinTask(@Param("ew") QueryWrapper<ProTaskWorkunit> query);


    List<ProTaskWorkunit> queryScheduledTasksBeenReported(ProTaskWorkunit proTaskWorkunit);


    /**
     * 新增任务工作单元
     *
     * @param proTaskWorkunit 任务工作单元
     * @return 结果
     */
    int insertProTaskWorkunit(ProTaskWorkunit proTaskWorkunit);


    /**
     * 修改任务工作单元
     *
     * @param proTaskWorkunit 任务工作单元
     * @return 结果
     */
    int updateProTaskWorkunit(ProTaskWorkunit proTaskWorkunit);

    /**
     * 修改任务工作单元排产时间、工作单元
     *
     * @param proTaskWorkunit 任务工作单元
     * @return 结果
     */
    void updateProTaskWorkunitTimeAndWorkunit(ProTaskWorkunit proTaskWorkunit);

    int cancelObj(List<ProTaskWorkunit> proTaskWorkunits);

    /**
     * 批量删除任务工作单元
     *
     * @param taskWorkunitIds 需要删除的任务工作单元主键集合
     * @return 结果
     */
    int deleteProTaskWorkunitByTaskWorkunitIds(Long[] taskWorkunitIds);

    /**
     * 删除任务工作单元信息
     *
     * @param taskWorkunitId 任务工作单元主键
     * @return 结果
     */
    int deleteProTaskWorkunitByTaskWorkunitId(Long taskWorkunitId);

    ProTaskWorkunit selectProTaskWorkunitByTaskId(Long taskId);

    /**
     * 查询任务工作单元列表
     *
     * @param query 任务工作单元
     * @return 任务工作单元集合
     */
    List<ProTaskWorkunit> selectListByQw(QueryWrapper<ProTaskWorkunit> query);

    String updateProTaskWorkunitlife(ProFeedback feedback);

    ProTaskWorkunit queryTaskScheduledForearliest(Long taskWorkunitId);

    ProTaskWorkunit queryTaskScheduledForearliestExec(Long taskId);

    /**
     * 下达生产
     *
     * @param taskWorkunitIds
     */
    void makeProduction(Long[] taskWorkunitIds);

    /**
     * 通过派工单ID查询关联工单
     *
     * @return
     */
    List<ProWorkorder> selectWorkorderTaskByQw(ProTaskWorkunitQuery proTaskWorkunit);

    List<ProTaskWorkunit> selectTaskWorkUnitJoinFeedback(QueryWrapper<ProTaskWorkunit> proTaskQo);

    List<ProTaskWorkunit> schedulingList(ProTaskWorkunitQuery proTaskWorkunit);

    void closeObj(List<ProTaskWorkunit> proTaskWorkunits);

    /**
     * 转自制
     * @param toSelfMadeParamList
     */
    void toSelfMade(List<TaskWorkunitToSelfMadeParam> toSelfMadeParamList);

    /**
     * 外协拆分
     * @param outsourceSplitParamList
     */
    void outsourceSplit(List<TaskWorkunitOutsourceSplitParam> outsourceSplitParamList);

    /**
     * 转外协
     * @param toOutsourceParamList
     */
    void toOutsource(List<TaskWorkunitToOutsourceParam> toOutsourceParamList);

    /**
     * 委外确认
     * @param taskWorkunitIds
     */
    void outsourceConfirm(List<Long> taskWorkunitIds);

}
