package com.ximai.mes.pro.service.impl.prototypeRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.vo.ProPrototypeRequestProcessToolVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestProcessToolMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessTool;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessToolService;

/**
 * 打样申请工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProPrototypeRequestProcessToolServiceImpl implements IProPrototypeRequestProcessToolService
{
    @Autowired
    private ProPrototypeRequestProcessToolMapper proPrototypeRequestProcessToolMapper;
    @Autowired
    private MdItemMapper mdItemMapper;
    /**
     * 查询打样申请工序工装夹具
     *
     * @param prototypeRequestProcessToolId 打样申请工序工装夹具主键
     * @return 打样申请工序工装夹具
     */
    @Override
    public ProPrototypeRequestProcessTool selectProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(Long prototypeRequestProcessToolId)
    {
        return proPrototypeRequestProcessToolMapper.selectProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(prototypeRequestProcessToolId);
    }

    /**
     * 查询打样申请工序工装夹具列表
     *
     * @param proPrototypeRequestProcessTool 打样申请工序工装夹具
     * @return 打样申请工序工装夹具
     */
    @Override
    public List<ProPrototypeRequestProcessTool> selectProPrototypeRequestProcessToolList(ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        return proPrototypeRequestProcessToolMapper.selectProPrototypeRequestProcessToolList(proPrototypeRequestProcessTool);
    }

    @Override
    public List<ProPrototypeRequestProcessToolVo> selectProPrototypeRequestProcessToolVoList(ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        List<ProPrototypeRequestProcessToolVo> rst = new ArrayList<ProPrototypeRequestProcessToolVo>();
        ProPrototypeRequestProcessTool query = new ProPrototypeRequestProcessTool();
        query.setPrototypeRequestId(proPrototypeRequestProcessTool.getPrototypeRequestId());
        List<ProPrototypeRequestProcessTool> list = proPrototypeRequestProcessToolMapper.selectProPrototypeRequestProcessToolList(query);
        List<Long> ids = list.stream().map(s->s.getToolId()).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if(ids.size()>0){
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getItemId(), s->s)));
        }
        list.forEach(s->{
            ProPrototypeRequestProcessToolVo vo = new ProPrototypeRequestProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if(toolMap.containsKey(s.getToolId())){
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样申请工序工装夹具
     *
     * @param proPrototypeRequestProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequestProcessTool(ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        return proPrototypeRequestProcessToolMapper.insertProPrototypeRequestProcessTool(proPrototypeRequestProcessTool);
    }

    /**
     * 修改打样申请工序工装夹具
     *
     * @param proPrototypeRequestProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequestProcessTool(ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        return proPrototypeRequestProcessToolMapper.updateProPrototypeRequestProcessTool(proPrototypeRequestProcessTool);
    }

    /**
     * 批量删除打样申请工序工装夹具
     *
     * @param prototypeRequestProcessToolIds 需要删除的打样申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolIds(Long[] prototypeRequestProcessToolIds)
    {
        return proPrototypeRequestProcessToolMapper.deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolIds(prototypeRequestProcessToolIds);
    }

    /**
     * 删除打样申请工序工装夹具信息
     *
     * @param prototypeRequestProcessToolId 打样申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(Long prototypeRequestProcessToolId)
    {
        return proPrototypeRequestProcessToolMapper.deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(prototypeRequestProcessToolId);
    }
}
