package com.ximai.mes.pro.service.impl.productionMake;

import java.util.List;

import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeProcessMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeBomMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeBom;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeBomService;

/**
 * 量产制作BOMService业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@Service
public class ProProductionMakeBomServiceImpl implements IProProductionMakeBomService
{
    @Autowired
    private ProProductionMakeBomMapper proProductionMakeBomMapper;
    @Autowired
    private ProProductionMakeProcessMapper productionMakeProcessMapper;

    /**
     * 查询量产制作BOM
     *
     * @param bomItemId 量产制作BOM主键
     * @return 量产制作BOM
     */
    @Override
    public ProProductionMakeBom selectProProductionMakeBomByBomItemId(Long bomItemId)
    {
        return proProductionMakeBomMapper.selectProProductionMakeBomByBomItemId(bomItemId);
    }

    /**
     * 查询量产制作BOM列表
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 量产制作BOM
     */
    @Override
    public List<ProProductionMakeBom> selectProProductionMakeBomList(ProProductionMakeBom proProductionMakeBom)
    {
        return proProductionMakeBomMapper.selectProProductionMakeBomList(proProductionMakeBom);
    }

    /**
     * 新增量产制作BOM
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 结果
     */
    @Override
    public int insertProProductionMakeBom(ProProductionMakeBom proProductionMakeBom)
    {
        return proProductionMakeBomMapper.insertProProductionMakeBom(proProductionMakeBom);
    }

    /**
     * 修改量产制作BOM
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 结果
     */
    @Override
    public int updateProProductionMakeBom(ProProductionMakeBom proProductionMakeBom)
    {
        return proProductionMakeBomMapper.updateProProductionMakeBom(proProductionMakeBom);
    }

    /**
     * 批量删除量产制作BOM
     *
     * @param bomItemIds 需要删除的量产制作BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeBomByBomItemIds(Long[] bomItemIds)
    {
        return proProductionMakeBomMapper.deleteProProductionMakeBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除量产制作BOM信息
     *
     * @param bomItemId 量产制作BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeBomByBomItemId(Long bomItemId)
    {
        return proProductionMakeBomMapper.deleteProProductionMakeBomByBomItemId(bomItemId);
    }
}
