package com.ximai.mes.pro.service;

import java.util.List;
import com.ximai.mes.pro.domain.ProBomItem;

/**
 * BOM组件Service接口
 *
 * @author zht
 * @date 2024-01-16
 */
public interface IProBomItemService
{
    /**
     * 查询BOM组件
     *
     * @param bomItemId BOM组件主键
     * @return BOM组件
     */
    public ProBomItem selectProBomItemByBomItemId(Long bomItemId);

    /**
     * 查询BOM组件列表
     *
     * @param proBomItem BOM组件
     * @return BOM组件集合
     */
    public List<ProBomItem> selectProBomItemList(ProBomItem proBomItem);

    /**
     * 新增BOM组件
     *
     * @param proBomItem BOM组件
     * @return 结果
     */
    public int insertProBomItem(ProBomItem proBomItem);

    /**
     * 修改BOM组件
     *
     * @param proBomItem BOM组件
     * @return 结果
     */
    public int updateProBomItem(ProBomItem proBomItem);

    /**
     * 批量删除BOM组件
     *
     * @param bomItemIds 需要删除的BOM组件主键集合
     * @return 结果
     */
    public int deleteProBomItemByBomItemIds(Long[] bomItemIds);

    /**
     * 删除BOM组件信息
     *
     * @param bomItemId BOM组件主键
     * @return 结果
     */
    public int deleteProBomItemByBomItemId(Long bomItemId);
}
