package com.ximai.mes.pro.schedule.impl.busi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;
import com.ximai.mes.pro.schedule.impl.AlgorithmResultProcessImpl;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品序列号生成
 */
@Component
public class ProductQrcodeBuild implements ScheduleBusiProcess{

    @Autowired
    private IProProductQrcodeRecordService productQrcodeRecordService;
    @Autowired
    private IProProductQrcodeRuleService productQrcodeRuleService;
    @Autowired
    private IProProductQrcodeRuleService proProductQrcodeRuleService;
    @Override
    public void execute(List<JobResult> jobResults) {
        jobResults.forEach(job->{
            job.getWorkorderList().forEach(workorder->{
                ProProductQrcodeRule rule = productQrcodeRuleService.selectProProductQrcodeRuleNewest(workorder.getProductId(), workorder.getClientCode());
                if(rule ==null){
                    return;
                }
                //wzc修改 有客户优先按照产品+客户匹配序列号规则绑定的最新打印模板，如果没有匹配到 按照产品匹配序列号规则绑定的最新打印模板（客户字段为空的）
                ProProductQrcodeRuleDto proProductQrcodeRuleDto= null;
                List<ProProductQrcodeRuleDto> list = null;
                if(StringUtils.isNotEmpty(workorder.getClientCode())){
                    QueryWrapper<ProProductQrcodeRule> query = new QueryWrapper<>();
                    query.eq("m.item_id", workorder.getProductId());
                    query.eq( "m.client_code", workorder.getClientCode());
                    query.orderByDesc("m.rule_id");
                    list = proProductQrcodeRuleService.selectProProductQrcodeRuleDtoList(query);
                }else{
                    QueryWrapper<ProProductQrcodeRule> query = new QueryWrapper<>();
                    query.eq("m.item_id", workorder.getProductId());
                    query.isNull( "m.client_code");
                    query.orderByDesc("m.rule_id");
                    list = proProductQrcodeRuleService.selectProProductQrcodeRuleDtoList(query);
                }
                if(list != null && list.size() > 0){
                    proProductQrcodeRuleDto = list.get(0);
                }else{
                    //后续再看是否需要报错
                }
                List<String> qrcodes = productQrcodeRuleService.buildQrcode(rule, job.getQuantity().intValue());
                for(String qrcode : qrcodes){
                    ProProductQrcodeRecordCreate create = new ProProductQrcodeRecordCreate();
                    create.setQrcode(qrcode);
                    create.initByWorkorder(workorder);
                    create.setItemDesc(rule.getItemDesc());
                    //产品序列打印记录增加模板相关内容
                    create.setTemplateId(proProductQrcodeRuleDto != null ? proProductQrcodeRuleDto.getTemplateId() : null);
                    create.setTemplateCode(proProductQrcodeRuleDto != null ? proProductQrcodeRuleDto.getTemplateCode() : null);
                    create.setTemplateName(proProductQrcodeRuleDto != null ? proProductQrcodeRuleDto.getTemplateName() : null);
                    create.setTemplateType(proProductQrcodeRuleDto != null ? proProductQrcodeRuleDto.getTemplateType() : null);
                    productQrcodeRecordService.insertProProductQrcodeRecord(create);
                }
            });
        });
    }

}
