package com.ximai.mes.pro.domain.vo;

import com.ximai.common.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class feedbackTaskVo {

        /**
         * 报工号
         */
        private String feedbackCode;

        /**
         * 报工数量
         */
        private BigDecimal quantityFeedback;


        /**
         * 合格数量
         */
        private BigDecimal quantityQualify;

        /**
         * 报废
         */
        private BigDecimal quantityUnqualify;


        /** 标准工时 */
        @Excel(name = "标准工时")
        private Long stdWorkingTime;

        /**
         * 实际工时
         */
        @Excel(name = "实际工时")
        private String machineTime;


        /**
         * 报工时间
         */
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        @Excel(name = "报工时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
        private Date feedbackTime;

        /**
         * 编排单号
         */
        private String arrangeCode;


}
