package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 生产版本工序传SAp对象
 * @author zht
 * @date 2024-02-20
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties
public class ProProductionSolutionProcessTo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     */
    @JSONField(name = "VORNR",ordinal = 0)
    private char idx;

    /**
     * 工作中心编码
     */
    @JSONField(name = "ARBPL" ,ordinal = 1)
    private String workstation_code;

    /**
     * 加工方式
     */
    @JSONField(name = "STEUS",ordinal = 2)
    private char processing_method;

    /**
     * 工序名称
     */
    @JSONField(name = "LTXA1",ordinal = 3)
    private String process_name;

    /**
     * 工序备注
     */
    @JSONField(name = "LTXA2",ordinal = 4)
    private String process_remark;

    /**
     * 基本数量
     */
    @JSONField(name = "BMSCH",ordinal = 5)
    private BigDecimal quantity;

    /**
     * 工序计量单位
     */
    @JSONField(name = "MEINH",ordinal = 6)
    private String unit_of_measure;

    /**
     * 雇员数量
     */
    @JSONField(name = "ANZMA",ordinal = 7)
    private int employees_num;

    /**
     * 标准工时
     */
    @JSONField(name = "VGW01",ordinal = 8)
    private BigDecimal std_working_time;

    /**
     * 工时单位
     */
    @JSONField(name = "VGE01",ordinal = 9)
    private String std_working_time_uom;

    /**
     * 采购信息记录号
     */
    @JSONField(name = "INFNR",ordinal = 10)
    private String procurement_information_id;

    /**
     * 供应商科目编号
     */
    @JSONField(name = "LIFNR",ordinal = 11)
    private String vendor_subject_id;

    /**
     * 净价
     */
    @JSONField(name = "PREIS",ordinal = 12)
    private BigDecimal net_price;

    /**
     * 采购组织
     */
    @JSONField(name = "EKORG",ordinal = 13)
    private String procurement_organization;

}
