package com.ximai.mes.pro.domain.productionMake;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.NoArgsConstructor;

/**
 * 量产制作对象 pro_production_make
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionMake extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 量产制作单ID */
    @TableId
    private Long productionMakeId;

    /** 量产制作单编码 */
    @Excel(name = "量产制作单编码")
    private String productionMakeCode;

    /** 量产申请单ID */
    @Excel(name = "量产申请单ID")
    private Long productionRequestId;

    /**
     * 样品单号
     */
    private String prototypeMakeCode;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 工艺路线ID */
    @Excel(name = "工艺路线ID")
    private Long routeId;

    /**
     * 采购单位
     */
    private String purchaseUnit;

    /**
     * 单位
     */
    //private String unit;

    /**
     * 换算值
     */
    private String conversionValue;

    /**
     * 品牌id
     */
    private String brandId;

    /** 长;单位cm */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /** 单层厚(单位丝) */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /** 层数 */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /** 单重(单位KG) */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /** 宽;单位cm */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /** 高;单位cm */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /** 印张长度 */
    @Excel(name = "印张长度")
    private BigDecimal printingPaperlenth;

    /** 印张宽度 */
    @Excel(name = "印张宽度")
    private Double printPaperwidth;

    /**
     * 存储地点
     */
    private String storePlace;

    /**
     * 尺码组id
     */
    private Long sizeGroupId;

    /** 派工倍数 */
    @Excel(name = "派工倍数")
    private BigDecimal sendworkMultiple;

    /** 行 */
    @Excel(name = "行")
    private Long rowNum;

    /**
     * 是否禁用
     */
    private String isDisable;

    /**
     * 是否创建新规格书
     */
    private String isCreateSpec;

    /**
     * 是否要鞋图
     */
    private String isNeedShoeImg;

    /**
     * 是否附样品
     */
    private String isAddSimple;

    /**
     * 是否唯一码产品
     */
    private String isUniqueCode;

    /**
     * 是否不考虑型体配色
     */
    private String isConsiderColor;

    /**
     * 产品材质
     */
    private String productMaterial;

    /** 确认人 */
    @Excel(name = "确认人")
    private String identifyingPeople;

    /** 确认日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "确认日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date identifyingDate;

    /** 印刷正面颜色 */
    @Excel(name = "印刷正面颜色")
    private String printingFrontcolor;
    //private String printingFrontcolorName;

    /** 印刷背面颜色 */
    @Excel(name = "印刷背面颜色")
    private String printingBackcolor;
    //private String printingBackcolorName;

    /** 产品正面 */
    @Excel(name = "产品正面")
    private String frontImg;

    /** 产品背面 */
    @Excel(name = "产品背面")
    private String backImg;

    /** 制作单状态 */
    @Excel(name = "制作单状态")
    private Integer productionMakeStatus;

}
