package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.pro.domain.sap.SAPDtoProWorkOrderBom;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产工单BOM对象 pro_work_order_bom
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderBom extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private Long bomItemId;

    /**
     * 生产工单ID
     */
    @Excel(name = "生产工单ID")
    private Long workorderId;


    private String workorderCode;
    /**
     * 物料ID
     */
    @Excel(name = "物料ID")
    private Long itemId;
    /**
     * 物料ID
     */
    @Excel(name = "物料编号")
    private Long itemCode;

    /**
     * sap的物料编号
     */
    @Excel(name = "sap的物料编号")
    private String sapItemCode;

    /**
     * 组件数量
     */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /**
     * 计量单位
     */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    private String alternativeBill;

    /**
     * 预留/相关需求的编号
     */
    @Excel(name = "预留/相关需求的编号")
    private String requirementNumber;

    /**
     * 预留/相关需求的项目编号
     */
    @Excel(name = "预留/相关需求的项目编号")
    private String requirementProjectNumber;

    /**
     * 存储地点
     */
    @Excel(name = "存储地点")
    private String storeAddr;

    /**
     * 报废百分比
     */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /**
     * 单位用量
     */
    @Excel(name = "单位用量")
    private String unitUsage;

    /**
     * 虚拟项目标识
     */
    @Excel(name = "虚拟项目标识")
    private String virtualProjectLog;

    /**
     * 副单位
     */
    @Excel(name = "副单位")
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    @Excel(name = "主副单位转换比例")
    private BigDecimal unitConvert;

    /**
     * 存储地点
     */
    @Excel(name = "存储地点")
    private String storeAddr2;

    /**
     * 编号
     */
    @Excel(name = "编号")
    private String processRef;

    /**
     * 是否倒冲
     */
    @Excel(name = "是否倒冲")
    private String isBackflush;


    private String itemName;

}
