package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ProWorkOrderSoDirectiveReport;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ProWorkOrderSoSizeItemReport;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 生产报工记录对象 pro_feedback
 *
 * @date 2022-07-10
 */
@Data
@NoArgsConstructor
public class ProFeedback extends BaseEntity {
    private static final long serialVersionUID = 1L;

    public ProFeedback(String arrangeCode, Long workorderId, Long taskId, Long taskWorkunitId) {
        this.arrangeCode = arrangeCode;
        this.taskId = taskId;
        this.taskWorkunitId = taskWorkunitId;
        this.workorderId = workorderId;
    }

    /**
     * 记录ID
     */
    @TableId
    private Long recordId;

    @TableField(exist = false)
    private String arrangeCode;

    @TableField(exist = false)
    private int closeType;

    @TableField(exist = false)
    private String assistProcessCode;


    private String operNo;
    private Long workunitId;

    /**
     * 报工单编号
     */
    private String feedbackCode;

    /**
     * 报工类型
     */
    private String feedbackType;

    /**
     * 工作中心ID
     */
    @Excel(name = "工作中心ID")
    private Long workstationId;

    /**
     * 工作中心编号
     */
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    private String workstationName;

    /**
     * 工序ID
     */
    private Long processId;

    /**
     * 工序编码
     */
    @Excel(name = "工序编码")
    private String processCode;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    private String isCheck;

    @TableField(exist = false)
    /**
     * 生产工单ID
     */
    @Excel(name = "生产工单ID")
    private Long workorderId;

    @TableField(exist = false)
    /**
     * 生产工单编号
     */
    @Excel(name = "生产工单编号")
    private String workorderCode;

    /**
     * 生产工单名称
     */
    @Excel(name = "生产工单名称")
    private String workorderName;

    /**
     * 生产任务ID
     */
    @Excel(name = "生产任务ID")
    private Long taskId;

    /**
     * 生产任务编号
     */
    @Excel(name = "生产任务编号")
    private String taskCode;

    /**
     * 产品物料ID
     */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /**
     * 产品物料编码
     */
    @Excel(name = "产品物料编码")
    private String itemCode;

    /**
     * sap产品物料编码
     */
    @Excel(name = "sap产品物料编码")
    private String sapItemCode;

    /**
     * 产品物料名称
     */
    @Excel(name = "产品物料名称")
    private String itemName;

    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String specification;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;


    /**
     * 排产数量
     */
    @Excel(name = "排产数量")
    private BigDecimal quantity;

    /**
     * 本次报工数量
     */
    @Excel(name = "本次报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @Excel(name = "合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @Excel(name = "不良品数量")
    private BigDecimal quantityUnqualify;

    @Excel(name = "待检测数量")
    private BigDecimal quantityUncheck;

    /**
     * 报工用户名
     */
    @Excel(name = "报工用户名")
    private String userName;
    private String userId;

    /**
     * 昵称
     */
    @Excel(name = "昵称")
    private String nickName;

    /**
     * 报工途径
     */
    @Excel(name = "报工途径")
    private String feedbackChannel;

    private String sapFeedbackCode;
    private String sapFeedbackItemCode;
    /**
     * 报工时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报工时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date feedbackTime;

    /**
     * 审批人员
     */
    @Excel(name = "审批人员")
    private String recordUser;

    /**
     * 审批人员名称
     */
    @Excel(name = "审批人员名称")
    private String recordNick;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createStartTime;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createEndTime;

    @ApiModelProperty("派工表ID")
    private Long taskWorkunitId;

    @ApiModelProperty("生产工单指令表ID")
    private Long workorderSoDirectiveId;

    @ApiModelProperty("生产工单尺码表ID")
    private Long workorderSoSizeItemId;

    @ApiModelProperty("生产工单尺码表ID集合")
    private String workorderSoSizeItemIds;

    @ApiModelProperty("生产工单尺码表集合")
    private String workorderSoSizes;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("已入库数量")
    private BigDecimal quantityStorage;

    @ApiModelProperty("打印模板")
    @TableField(exist = false)
    private String printTemplate;


    private String machineTime;
    private String breakTime;
    /**
     * 打印内容
     */
    @Excel(name = "打印内容")
    @TableField(exist = false)
    private String printContents;

    @ApiModelProperty("标签二维码")
    private String qrcode;

    @ApiModelProperty("Decompression")
    private String decompressionValue;

    private String sapRequestParam;
    private String sapResponse;

    public void initValue(ProWorkorder workorder) {
        this.setWorkorderCode(workorder.getWorkorderCode());
        this.setWorkorderName(workorder.getWorkorderName());
        this.setUnitOfMeasure(workorder.getUnitOfMeasure());
        this.setItemId(workorder.getProductId());
        this.setQuantity(workorder.getQuantity());
        this.setItemCode(workorder.getProductCode());
        this.setItemName(workorder.getProductName());
    }

    public void initValue(MdItem mdItem) {
        this.setItemName(mdItem.getItemName());
        this.setItemCode(mdItem.getItemCode());
        this.setSpecification(mdItem.getSpecification());
    }

    public void initValue(MdWorkstation workstation) {
        this.setWorkstationId(workstation.getWorkstationId());
        this.setWorkstationCode(workstation.getWorkstationCode());
        this.setWorkstationName(workstation.getWorkstationName());
    }

    public void initValue(ProProcess process) {
        this.setProcessId(process.getProcessId());
        this.setProcessCode(process.getProcessCode());
        this.setProcessName(process.getProcessName());
    }
}
