package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import io.swagger.annotations.ApiOperation;
import com.ximai.mes.pro.domain.ProProductQrcodeRecord;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordDto;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordQuery;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordExcelExport;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品序列号打印记录Controller
 *
 * @author generator
 * @date 2024-08-31
 */
@RestController
@RequestMapping("/pro/qrcodeRecord")
public class ProProductQrcodeRecordController extends BaseController
{
    @Autowired
    private IProProductQrcodeRecordService proProductQrcodeRecordService;

    /**
     * 查询产品序列号打印记录列表
     */
    @ApiOperation("查询产品序列号打印记录列表")
    @PreAuthorize("@ss.hasPermi('pro:qrcodeRecord:list')")
    @GetMapping("/list")
    public TableDataInfo<ProProductQrcodeRecordDto> list(ProProductQrcodeRecordQuery proProductQrcodeRecordQuery) {
        startPage();
        QueryWrapper<ProProductQrcodeRecord> query = new QueryWrapper<>();
        query.eq(proProductQrcodeRecordQuery.getItemId()!=null, "m.item_id", proProductQrcodeRecordQuery.getItemId());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getItemCode()), "m.item_code", proProductQrcodeRecordQuery.getItemCode());
        query.eq(proProductQrcodeRecordQuery.getWorkOrderId()!=null, "m.work_order_id", proProductQrcodeRecordQuery.getWorkOrderId());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getWorkOrderNo()), "m.work_order_no", proProductQrcodeRecordQuery.getWorkOrderNo());
        query.eq(proProductQrcodeRecordQuery.getPrintTime()!=null, "m.print_time", proProductQrcodeRecordQuery.getPrintTime());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getQrcode()), "m.qrcode", proProductQrcodeRecordQuery.getQrcode());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getClientCode()), "m.client_code", proProductQrcodeRecordQuery.getClientCode());
        query.like(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getClientName()), "m.client_name", "%" + proProductQrcodeRecordQuery.getClientName() + "%");
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRecordQuery.getItemDesc()), "m.item_desc", proProductQrcodeRecordQuery.getItemDesc());
        List<ProProductQrcodeRecordDto> list = proProductQrcodeRecordService.selectProProductQrcodeRecordDtoList(query);
        return getDataTable(list);
    }

    /**
     * 获取产品序列号打印记录详细信息
     */
    @ApiOperation("获取产品序列号打印记录详细信息")
    @PreAuthorize("@ss.hasPermi('pro:qrcodeRecord:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult<ProProductQrcodeRecordDto> getInfo(@PathVariable("recordId") Long recordId) {
        return AjaxResult.success(proProductQrcodeRecordService.selectProProductQrcodeRecordDtoByRecordId(recordId));
    }

    /**
     * 新增产品序列号打印记录
     */
    @ApiOperation("新增产品序列号打印记录")
    @PreAuthorize("@ss.hasPermi('pro:qrcodeRecord:add')")
    @Log(title = "产品序列号打印记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductQrcodeRecordCreate proProductQrcodeRecordCreate) {
        return toAjax(proProductQrcodeRecordService.insertProProductQrcodeRecord(proProductQrcodeRecordCreate));
    }

    /**
     * 修改产品序列号打印记录
     */
    @ApiOperation("修改产品序列号打印记录")
    @PreAuthorize("@ss.hasPermi('pro:qrcodeRecord:edit')")
    @Log(title = "产品序列号打印记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductQrcodeRecordUpdate proProductQrcodeRecordUpdate) {
        return toAjax(proProductQrcodeRecordService.updateProProductQrcodeRecord(proProductQrcodeRecordUpdate));
    }

    /**
     * 删除产品序列号打印记录
     */
    @ApiOperation("删除产品序列号打印记录")
    @PreAuthorize("@ss.hasPermi('pro:qrcodeRecord:remove')")
    @Log(title = "产品序列号打印记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds) {
        return toAjax(proProductQrcodeRecordService.deleteProProductQrcodeRecordByRecordIds(recordIds));
    }
}
