package com.ximai.mes.od.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @since created by hyy on 2024-01-23
 */
@Data
public class PurchaseOrderDetailVo {
    /**
     * 产品id
     */
    private Long itemId;

    /**
     * 产品代码
     */
    private String itemNo;

    /**
     * 产品名称
     */
    private String itemName;

    /**
     * 总数量(num + loss_num)
     */
    private Long totalNum;

    /**
     * 数量
     */
    private Long num;

    /**
     * loss数量
     */
    private Long lossNum;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 装运点
     */
    private String shipmentPointNo;

    /**
     * 存储地点
     */
    private String storeAddr;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 要求交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expectDeliveryDate;

    /**
     * 定价值
     */
    private String pricingVal;

    /**
     * 报价单位(和客户确定价格的单位)
     */
    private String offerUnit;

    /**
     * 销售单位(销售订单行数量的单位)
     */
    private String saleUnit;

    /**
     * 尺码单位
     */
    private String sizeUnit;

    /**
     * 客户订单号
     */
    private String clientOrderNo;

    /**
     * 客户产品代码
     */
    private String clientItemNo;

    /**
     * 客户产品名称
     */
    private String clientItemName;

    /**
     * 客户尺码单位
     */
    private String clientSizeUnit;

    /**
     * 客户指令号
     */
    private String clientCmd;

    /**
     * 客户单重
     */
    private String clientKg;

    /**
     * 销线
     */
    private String salePath;

    /**
     * 段别
     */
    private String segment;

    /**
     * 版面
     */
    private String layout;

    /**
     * 季度
     */
    private String quarter;

    /**
     * 整/半码
     */
    private Integer wholeSize;

    /**
     * 特殊尺码
     */
    private Integer specSize;

    /**
     * po_no
     */
    private String poNo;

    /**
     * wip_no
     */
    private String wipNo;

    /**
     * 装箱数
     */
    private Long packingNum;

    /**
     * 周期
     */
    private String cycle;

    /**
     * sk_no
     */
    private String skNo;

    /**
     * 专利号
     */
    private String patentNo;

    /**
     * 材质描述
     */
    private String materialDesc;

    /**
     * 签收人
     */
    private String signer;

    /**
     * ship_to_id
     */
    private String shipToId;

    /**
     * 尺码组
     */
    private String sizeGroup;

    /**
     * 尺码
     */
    private String size;

    /**
     * 订单量
     */
    private Long orderNum;

    /**
     * 条码
     */
    private String barCode;

    /**
     * 印刷方向
     */
    private String printingDirection;

    /**
     * 产品规格
     */
    private String prodSpec;

    /**
     * 客户工厂代号
     */
    private String plantCode;

    /**
     * 包装方式
     */
    private String packMode;


}
