package com.ximai.mes.od.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.od.domain.OdSalesOrderDetail;
import com.ximai.mes.od.service.IOdSalesOrderDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 销售订单详情Controller
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/od/salesOrderDetail")
public class OdSalesOrderDetailController extends BaseController {
    @Autowired
    private IOdSalesOrderDetailService odSalesOrderDetailService;

    /**
     * 查询销售订单详情列表
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrderDetail:list')")
    @GetMapping("/list")
    public TableDataInfo list(OdSalesOrderDetail odSalesOrderDetail) {
        startPage();
        List<OdSalesOrderDetail> list = odSalesOrderDetailService.selectOdSalesOrderDetailList(odSalesOrderDetail);
        return getDataTable(list);
    }
    /**
     * 获取销售订单详情详细信息
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrderDetail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(odSalesOrderDetailService.selectOdSalesOrderDetailById(id));
    }

    /**
     * 新增销售订单详情
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrderDetail:add')")
    @Log(title = "销售订单详情", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody OdSalesOrderDetail odSalesOrderDetail) {
        return toAjax(odSalesOrderDetailService.insertOdSalesOrderDetail(odSalesOrderDetail));
    }

    /**
     * 修改销售订单详情
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrderDetail:edit')")
    @Log(title = "销售订单详情", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody OdSalesOrderDetail odSalesOrderDetail) {
        return toAjax(odSalesOrderDetailService.updateOdSalesOrderDetail(odSalesOrderDetail));
    }

    /**
     * 删除销售订单详情
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrderDetail:remove')")
    @Log(title = "销售订单详情", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(odSalesOrderDetailService.deleteOdSalesOrderDetailByIds(ids));
    }
}
