package com.ximai.mes.md.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.Date;

@Data
public class MdClientItemVo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @TableId(type = IdType.AUTO)
    private String id;

    /** 客户编码 */
    @TableField(exist = false)
    private String clientCode;

    @TableField(exist = false)
    private String itemName;

    @Excel(name = "产品编码")
    private String itemCode;

    /** 客户产品名称 */
    @Excel(name = "客户产品名称")
    private String clientItemName;

    /** 客户产品编码 */
    @Excel(name = "客户产品编码")
    private String clientItemCode;
    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
