package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSalesReasonMapper;
import com.ximai.mes.md.domain.MdSalesReason;
import com.ximai.mes.md.service.IMdSalesReasonService;

/**
 * 销售订单原因Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSalesReasonServiceImpl implements IMdSalesReasonService
{
    @Autowired
    private MdSalesReasonMapper mdSalesReasonMapper;

    /**
     * 查询销售订单原因
     *
     * @param id 销售订单原因主键
     * @return 销售订单原因
     */
    @Override
    public MdSalesReason selectMdSalesReasonById(String id)
    {
        return mdSalesReasonMapper.selectMdSalesReasonById(id);
    }

    /**
     * 查询销售订单原因列表
     *
     * @param mdSalesReason 销售订单原因
     * @return 销售订单原因
     */
    @Override
    public List<MdSalesReason> selectMdSalesReasonList(MdSalesReason mdSalesReason)
    {
        return mdSalesReasonMapper.selectMdSalesReasonList(mdSalesReason);
    }

    /**
     * 新增销售订单原因
     *
     * @param mdSalesReason 销售订单原因
     * @return 结果
     */
    @Override
    public int insertMdSalesReason(MdSalesReason mdSalesReason)
    {
        mdSalesReason.setCreateTime(DateUtils.getNowDate());
        return mdSalesReasonMapper.insertMdSalesReason(mdSalesReason);
    }

    /**
     * 修改销售订单原因
     *
     * @param mdSalesReason 销售订单原因
     * @return 结果
     */
    @Override
    public int updateMdSalesReason(MdSalesReason mdSalesReason)
    {
        mdSalesReason.setUpdateTime(DateUtils.getNowDate());
        return mdSalesReasonMapper.updateMdSalesReason(mdSalesReason);
    }

    /**
     * 批量删除销售订单原因
     *
     * @param ids 需要删除的销售订单原因主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesReasonByIds(String[] ids)
    {
        return mdSalesReasonMapper.deleteMdSalesReasonByIds(ids);
    }

    /**
     * 删除销售订单原因信息
     *
     * @param id 销售订单原因主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesReasonById(String id)
    {
        return mdSalesReasonMapper.deleteMdSalesReasonById(id);
    }
}
