package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductCustomerMapper;
import com.ximai.mes.md.domain.MdProductCustomer;
import com.ximai.mes.md.service.IMdProductCustomerService;

/**
 * 产品客户配置Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductCustomerServiceImpl implements IMdProductCustomerService
{
    @Autowired
    private MdProductCustomerMapper mdProductCustomerMapper;

    /**
     * 查询产品客户配置
     *
     * @param productCustomerId 产品客户配置主键
     * @return 产品客户配置
     */
    @Override
    public MdProductCustomer selectMdProductCustomerByProductCustomerId(Long productCustomerId)
    {
        return mdProductCustomerMapper.selectMdProductCustomerByProductCustomerId(productCustomerId);
    }

    /**
     * 查询产品客户配置列表
     *
     * @param mdProductCustomer 产品客户配置
     * @return 产品客户配置
     */
    @Override
    public List<MdProductCustomer> selectMdProductCustomerList(MdProductCustomer mdProductCustomer)
    {
        return mdProductCustomerMapper.selectMdProductCustomerList(mdProductCustomer);
    }

    /**
     * 新增产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    @Override
    public int insertMdProductCustomer(MdProductCustomer mdProductCustomer)
    {
        return mdProductCustomerMapper.insertMdProductCustomer(mdProductCustomer);
    }

    /**
     * 修改产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    @Override
    public int updateMdProductCustomer(MdProductCustomer mdProductCustomer)
    {
        return mdProductCustomerMapper.updateMdProductCustomer(mdProductCustomer);
    }

    /**
     * 批量删除产品客户配置
     *
     * @param productCustomerIds 需要删除的产品客户配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductCustomerByProductCustomerIds(Long[] productCustomerIds)
    {
        return mdProductCustomerMapper.deleteMdProductCustomerByProductCustomerIds(productCustomerIds);
    }

    /**
     * 删除产品客户配置信息
     *
     * @param productCustomerId 产品客户配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductCustomerByProductCustomerId(Long productCustomerId)
    {
        return mdProductCustomerMapper.deleteMdProductCustomerByProductCustomerId(productCustomerId);
    }
}
