package com.ximai.mes.md.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.core.domain.SapResult;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.common.core.domain.entity.SysDictData;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.bean.BeanUtils;
import com.ximai.common.utils.bean.BeanValidators;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.excel.ExcelReader;
import com.ximai.mes.md.domain.*;
import com.ximai.mes.md.dto.MdItemExcelImport;
import com.ximai.mes.md.dto.MdItemWarehouseCreate;
import com.ximai.mes.md.dto.MdItemWarehouseDto;
import com.ximai.mes.md.dto.MdItemWarehouseUpdate;
import com.ximai.mes.md.mapper.ItemTypeMapper;
import com.ximai.mes.md.mapper.MdBaseInfoMapper;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.md.mapper.MdProductLookMapper;
import com.ximai.mes.md.service.*;
import com.ximai.mes.md.vo.ItemUpdateMesVo;
import com.ximai.mes.md.vo.MdItemVo;
import com.ximai.mes.md.vo.SapItemVo;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBom;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionBomMapper;
import com.ximai.mes.remote.ErpService;
import com.ximai.mes.remote.dto.*;
import com.ximai.system.service.ISysDictDataService;
import com.ximai.system.strategy.AutoCodeUtil;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MdItemServiceImpl implements IMdItemService {

    private static final Logger log = LoggerFactory.getLogger(MdItemServiceImpl.class);

    @Autowired
    private MdItemMapper mdItemMapper;

    @Autowired
    private IMdBaseInfoService iMdBaseInfoService;

    @Autowired
    private IMdProductLookService iMdProductLookService;

    @Autowired
    private IMdProductPublishedConfService iMdProductPublishedConfService;

    @Autowired
    private IMdSaleUnitService iMdSaleUnitService;

    @Autowired
    private ISysDictDataService dictDataService;

    @Autowired
    private MdProductLookMapper productLookMapper;

    @Autowired
    protected Validator validator;
    @Autowired
    private AutoCodeUtil autoCodeUtil;
    @Autowired
    private IMdUnitMeasureService mdUnitMeasureService;
    @Autowired
    private IItemTypeService iItemTypeService;

    @Autowired
    private ItemTypeMapper itemTypeMapper;

    @Autowired
    private ProProductionSolutionBomMapper proProductionSolutionBomMapper;

    @Autowired
    private MdBaseInfoMapper mdBaseInfoMapper;
    @Autowired
    private ErpService erpService;
    @Autowired
    private IMdItemWarehouseService itemWarehouseService;


    @Override
    public List<MdItemVo> selectMdItemList(MdItem mdItem) {
        return mdItemMapper.selectMdItemList(mdItem);
    }


    @Override
    public MdItemType getItemTypeByItemId(Long id) {
        //        List<MdItemType> collect = Stream.of(mdItemType).filter(x -> x.getAncestors().split(",").length == 2).collect(Collectors.toList());
//
//        if (collect==null) {
//            return null;
//        }

        return mdItemMapper.selectMdItemTypeById(id);
    }


    @Override
    public MdItem selectMdItemById(Long itemId) {
        return mdItemMapper.selectMdItemById(itemId);
    }


    @Override
    public String checkItemCodeUnique(MdItem mdItem) {
        MdItem item = mdItemMapper.checkItemCodeUnique(mdItem);
        Long itemId = mdItem.getItemId() == null ? -1L : mdItem.getItemId();
        if (StringUtils.isNotNull(item) && item.getItemId().longValue() != itemId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        } else {
            return UserConstants.UNIQUE;
        }
    }

    @Override
    public List<MdItem> selectListByQw(QueryWrapper<MdItem> query) {
        return mdItemMapper.selectListByQw(query);
    }

    @Override
    public String checkItemNameUnique(MdItem mdItem) {
        MdItem item = mdItemMapper.checkItemNameUnique(mdItem);
        Long itemId = mdItem.getItemId() == null ? -1L : mdItem.getItemId();
        if (StringUtils.isNotNull(item) && item.getItemId().longValue() != itemId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        } else {
            return UserConstants.UNIQUE;
        }
    }

    @Override
    public int insertMdItem(MdItem mdItem) {
        mdItem.setCreateTime(new Date());
        return mdItemMapper.insertMdItem(mdItem);
    }

    @Override
    public int updateMdItem(MdItem mdItem) {
        int i = mdItemMapper.updateMdItem(mdItem);
        //保存产品基本信息
        if (ObjectUtil.isNotEmpty(mdItem.getBaseInfo()) && mdItem.getBaseInfo().getItemId() != null) {
            MdBaseInfo baseInfo = mdItem.getBaseInfo();
            if (StringUtils.isEmpty(baseInfo.getCreateBy())) {
                baseInfo.setCreateBy(mdItem.getUpdateBy());
                iMdBaseInfoService.insertMdBaseInfo(mdItem.getBaseInfo());
            } else {
                baseInfo.setUpdateBy(mdItem.getUpdateBy());
                iMdBaseInfoService.updateMdBaseInfo(mdItem.getBaseInfo());
            }
        }

        //保存产品外观信息
        if (ObjectUtil.isNotEmpty(mdItem.getLook()) && mdItem.getLook().getItemId() != null) {
            MdProductLook look = mdItem.getLook();
            //如果创建信息是null，则新增
            if (StringUtils.isEmpty(look.getCreateBy())) {
                look.setCreateBy(mdItem.getUpdateBy());
                iMdProductLookService.insertMdProductLook(look);
            } else {
                look.setUpdateBy(mdItem.getUpdateBy());
                iMdProductLookService.updateMdProductLook(look);
            }
        }

        //保存产品参数配置信息
        if (ObjectUtil.isNotEmpty(mdItem.getPublishedConf()) && mdItem.getPublishedConf().getItemId() != null) {
            MdProductPublishedConf publishedConf = mdItem.getPublishedConf();
            if (StringUtils.isEmpty(publishedConf.getCreateBy())) {
                publishedConf.setCreateBy(mdItem.getUpdateBy());
                iMdProductPublishedConfService.insertMdProductPublishedConf(publishedConf);
            } else {
                publishedConf.setUpdateBy(mdItem.getUpdateBy());
                iMdProductPublishedConfService.updateMdProductPublishedConf(publishedConf);
            }
        }

        //保存销售单位转换信息
        if (ObjectUtil.isNotEmpty(mdItem.getSaleUnit()) && mdItem.getSaleUnit().getItemId() != null) {
            MdSaleUnit saleUnit = mdItem.getSaleUnit();
            if (StringUtils.isEmpty(saleUnit.getCreateBy())) {
                saleUnit.setCreateBy(mdItem.getUpdateBy());
                iMdSaleUnitService.insertMdSaleUnit(saleUnit);
            } else {
                saleUnit.setUpdateBy(mdItem.getUpdateBy());
                iMdSaleUnitService.updateMdSaleUnit(saleUnit);
            }
        }
        return i;
    }


    /**
     * 根据ep传mes进行修改
     *
     * @param mdItem
     * @return
     */
    @Override
    public int updateMdItems(MdItem mdItem, ItemUpdateMesVo mdItemVo) {
        int i = mdItemMapper.updateMdItem(mdItem);

        MdItem mdItem1 = mdItemMapper.selectMdItemByCodes(mdItem.getSapItemCode());
        //保存产品基本信息
        MdBaseInfo baseInfo = new MdBaseInfo();
        MdBaseInfo mdBaseInfo = mdBaseInfoMapper.selectMdBaseInfoByItemIds(mdItem.getItemId());
        if (ObjectUtil.isEmpty(mdBaseInfo)) {
            BeanUtils.copyProperties(mdItemVo, baseInfo);
            baseInfo.setUpdateBy("ep");
            baseInfo.setItemId(mdItem1.getItemId());
            iMdBaseInfoService.insertMdBaseInfo(baseInfo);
        } else {
            BeanUtils.copyProperties(mdItemVo, baseInfo);
            baseInfo.setUpdateBy("ep");
            baseInfo.setItemId(mdItem1.getItemId());
            iMdBaseInfoService.updateMdBaseInfo(baseInfo);
        }


        //保存产品外观信息
        if (ObjectUtil.isNotEmpty(mdItemVo.getProductLook())) {
            MdProductLook look = new MdProductLook();
            MdProductLook mdProductLook = iMdProductLookService.selectMdProductLookByItemId(mdItem.getItemId());
            //如果创建信息是null，则新增
            if (ObjectUtil.isEmpty(mdProductLook)) {
                BeanUtils.copyProperties(mdItemVo.getProductLook(), look);
                if (StringUtils.isNotNull(look.getFrontColor())) {
                    String[] frontColor = look.getFrontColor();
                    String join = String.join(",", frontColor);
                    look.setFrontColorName(join);
                }
                if (StringUtils.isNotNull(look.getOppositeColor())) {
                    String[] frontColor = look.getOppositeColor();
                    String join = String.join(",", frontColor);
                    look.setOppositeColorName(join);
                }
                look.setUpdateBy("ep");
                look.setItemId(mdItem1.getItemId());
                iMdProductLookService.insertMdProductLook(look);
            } else {
                BeanUtils.copyProperties(mdItemVo.getProductLook(), look);
                if (StringUtils.isNotNull(look.getFrontColor())) {
                    String[] frontColor = look.getFrontColor();
                    String join = String.join(",", frontColor);
                    look.setFrontColorName(join);

                }
                if (StringUtils.isNotNull(look.getOppositeColor())) {
                    String[] frontColor = look.getOppositeColor();
                    String join = String.join(",", frontColor);
                    look.setOppositeColorName(join);
                }
                look.setUpdateBy("ep");
                look.setItemId(mdItem1.getItemId());
                iMdProductLookService.updateMdProductLook(look);
            }
        }


        return i;
    }


    @Override
    public int deleteByItemIds(Long[] itemIds) {
        return mdItemMapper.deleteMdItemByIds(itemIds);
    }

    @Override
    public int deleteByItemId(Long itemId) {
        return mdItemMapper.deleteMdItemById(itemId);
    }

    @Override
    public void becomeFormalProduct(Long[] itemIds) {
        mdItemMapper.becomeFormalProduct(itemIds);

    }

    public void handleResult(Long itemId, String sapItemCode, String message) {
        MdItem mdItem = mdItemMapper.selectMdItemById(itemId);
        mdItem.setSapItemCode(sapItemCode);
        mdItem.setMessage(message);
        mdItemMapper.updateMdItem(mdItem);
    }

    @Override
    public void importMdItem(InputStream io, boolean updateSupport) {
        ExcelReader.read(io, MdItemExcelImport.class, this::importData);
    }

    private void importData(MdItemExcelImport mdItem){
        String operaName = SecurityUtils.getLoginUser().getUsername();
        MdItem item = mdItemMapper.selectMdItemByItemName(mdItem.getItemName());
        if (StringUtils.isNull(item)) {
            item = BeanUtil.copyProperties(mdItem, MdItem.class);
            BeanValidators.validateWithException(validator, mdItem);
            String itemCode = autoCodeUtil.genSerialCode(UserConstants.ITEM_CODE, "");
            item.setItemCode(itemCode);
            //处理计量单位
            if (StringUtils.isNotEmpty(mdItem.getUnitOfMeasure())) {
                MdUnitMeasure mdUnitMeasure = mdUnitMeasureService.selectMdUnitMeasureByMeasureName(mdItem.getUnitOfMeasure());
                item.setUnitOfMeasure(mdUnitMeasure.getMeasureCode());
            }
            //处理物料/产品类型
            if (StringUtils.isNotEmpty(mdItem.getItemTypeName())) {
                MdItemType mdItemType = iItemTypeService.selectItemTypeByItemTypeName(mdItem.getItemTypeName());
                if (StringUtils.isNotNull(mdItemType)) {
                    item.setItemTypeId(mdItemType.getItemTypeId());
                    item.setItemTypeCode(mdItemType.getItemTypeCode());
                    item.setItemTypeName(mdItemType.getItemTypeName());
                    item.setItemOrProduct(mdItemType.getItemOrProduct());
                }
            }
            item.setEnableFlag("Y");
            item.setCreateBy(operaName);
            this.insertMdItem(item);
        } else {
            BeanUtil.copyProperties(mdItem, item);
            BeanValidators.validateWithException(validator, item);
            item.setUpdateBy(operaName);
            this.updateMdItem(item);
        }
    }

    /**
     * 产品物料接收EP
     *
     * @param mdItemVo
     * @return
     */
    @Override
    @Transactional
    public int itemCreate(ItemUpdateMesVo mdItemVo) {
        // 产品物料EP传MES
        MdItem mdItem = new MdItem();
        BeanUtils.copyProperties(mdItemVo, mdItem);
        int i = 0;
        //新增
        if (mdItemVo.getUpdateLog().equals("I")) {
            MdItem mdItem1 = mdItemMapper.selectMdItemByCodes(mdItem.getSapItemCode());
            if (Objects.isNull(mdItem1)) {
                List<MdItem> mdItems = mdItemMapper.selectMdItemByCode(mdItem.getItemCode());
                if (CollUtil.isNotEmpty(mdItems)) {
                    throw new ServiceException(MessageUtils.message("pro.material.error.error3", mdItem.getItemCode()));
                }
                MdItem item = new MdItem();
                item.setItemName(mdItem.getItemName());
                List<MdItemVo> mdItemVos = mdItemMapper.selectMdItemLists(item);
                mdItem.setCreateBy("ep");
                mdItem.setCreateTime(DateUtils.getNowDate());
                MdItemType type = itemTypeMapper.selectItemTypeCode(mdItemVo.getItemTypeCode());
                if (StringUtils.isNotNull(type)) {
                    mdItem.setItemTypeId(type.getItemTypeId());
                    mdItem.setItemTypeCode(type.getItemTypeCode());
                    mdItem.setItemTypeName(type.getItemTypeName());
                    mdItem.setItemOrProduct(type.getItemOrProduct());
                }
                mdItem.setItemOrProduct(mdItemVo.getItemOrProduct());
                insertEpMdItem(mdItem, mdItemVo);
                return 1;
            } else {
                //修改
                mdItem.setUpdateBy("ep");
                mdItem.setUpdateTime(DateUtils.getNowDate());
                mdItem.setItemId(mdItem1.getItemId());
                MdItemType type = itemTypeMapper.selectItemTypeCode(mdItemVo.getItemTypeCode());
                if (StringUtils.isNotNull(type)) {
                    mdItem.setItemTypeId(type.getItemTypeId());
                    mdItem.setItemTypeCode(type.getItemTypeCode());
                    mdItem.setItemTypeName(type.getItemTypeName());
                    mdItem.setItemOrProduct(type.getItemOrProduct());
                }
                mdItem.setItemOrProduct(mdItemVo.getItemOrProduct());
                updateMdItems(mdItem, mdItemVo);
                return 2;
            }

        } else if (mdItemVo.getUpdateLog().equals("D")) {
            //删除
            List<MdItem> mdItems = mdItemMapper.selectMdItemByCode(mdItem.getItemCode());
            if (CollUtil.isEmpty(mdItems)) {
                throw new ServiceException(MessageUtils.message("basic.data.deleted"));
            }
            mdItems.forEach(c -> {
                ProProductionSolutionBom proProductionSolutionBom = new ProProductionSolutionBom();
                proProductionSolutionBom.setItemId(c.getItemId());
                List<ProProductionSolutionBom> proProductionSolutionBoms = proProductionSolutionBomMapper.selectProProductionSolutionBomList(proProductionSolutionBom);
                if (proProductionSolutionBoms.size() != 0) {
                    throw new ServiceException(MessageUtils.message("md.material.data.limit.can.not.delete"));
                }
            });
            MdItem mdItem1 = mdItemMapper.selectMdItemByCodes(mdItem.getSapItemCode());
            mdItemMapper.deleteMdItemByEpItemCode(mdItem.getItemCode());
            mdBaseInfoMapper.deleteMdBaseInfoByItemId(mdItem1.getItemId());
            productLookMapper.deleteMdProductLookByItemId(mdItem1.getItemId());

            return 3;
        }
        return i;
    }

    //ep传mes新增接口
    private int insertEpMdItem(MdItem mdItem, ItemUpdateMesVo mdItemVo) {

        mdItemMapper.insertMdItem(mdItem);
        //根据编码查看数据，替换子类的ID
        MdItem mdItem1 = mdItemMapper.selectMdItemByCodes(mdItem.getSapItemCode());

        //保存产品基本信息
        MdBaseInfo baseInfo = new MdBaseInfo();
        BeanUtils.copyProperties(mdItemVo, baseInfo);
        baseInfo.setCreateBy("ep");
        baseInfo.setItemId(mdItem1.getItemId());
        iMdBaseInfoService.insertMdBaseInfo(baseInfo);


        //保存产品外观信息
        if (ObjectUtil.isNotEmpty(mdItemVo.getProductLook())) {
            MdProductLook look = new MdProductLook();
            //如果创建信息是null，则新增
            BeanUtils.copyProperties(mdItemVo.getProductLook(), look);

            if (StringUtils.isNotNull(look.getFrontColor())) {
                String[] frontColor = look.getFrontColor();
                String join = String.join(",", frontColor);
                look.setFrontColorName(join);

            }
            if (StringUtils.isNotNull(look.getOppositeColor())) {
                String[] frontColor = look.getOppositeColor();
                String join = String.join(",", frontColor);
                look.setOppositeColorName(join);
            }
            look.setCreateBy("ep");
            look.setItemId(mdItem1.getItemId());
            iMdProductLookService.insertMdProductLook(look);
        }


        int i = 0;
        return i;
    }

    @Override
    public void syncErpData() {
        //优先更新修改数据
        this.syncEditErpData();
        //新增创建数据
        this.syncAddErpData();
    }

    @Transactional
    public void syncAddErpData(){
        MdItemErpQuery itemErpQuery = new MdItemErpQuery();
        //获取最晚创建时间
        Date maxErpCreateTime = mdItemMapper.maxErpCreateTime();
        if(maxErpCreateTime==null){
            Calendar curr = Calendar.getInstance();
            curr.set(Calendar.YEAR, 2000);
            maxErpCreateTime = curr.getTime();
        }
        QueryWrapper<MdItem> itemQuery = new QueryWrapper<>();
        itemQuery.eq("erp_create_time", maxErpCreateTime);
        List<MdItem> existList = mdItemMapper.selectListByQw(itemQuery);
        Map<String,MdItem> existMap = existList.stream().collect(Collectors.toMap(s->s.getItemCode(),s->s));
        ErpPageParams.Sort sort = new ErpPageParams.Sort(){{
            List<ErpPageParams.Order> orders = new ArrayList<>();
            orders.add(new ErpPageParams.Order("createDate","asc"));
            this.setOrders(orders);
        }};
        itemErpQuery.setSort(sort);
        itemErpQuery.setGtEqCreateDate(maxErpCreateTime);
        itemErpQuery.setCurrent(1);
        itemErpQuery.setPageSize(1000);//每次抓取1000行
        List<MdItemErpDto> list = erpService.getItemList(itemErpQuery).getData();
        list.forEach(s->{
            if("Y".equalsIgnoreCase(s.getVerifyStatus())){
                if(StringUtils.isNotEmpty(s.getItemCode()) && !existMap.containsKey(s.getItemCode())){
                    MdItem insertTemp = BeanUtil.toBean(s, MdItem.class);
                    this.insertMdItem(insertTemp);
                    //保存库房明细
                    List<MdItemWarehouseErpDto> detailList = s.getWarehouseList();
                    detailList.forEach(s2->{
                        MdItemWarehouseCreate insertDetail = BeanUtil.toBeanIgnoreError(s2, MdItemWarehouseCreate.class);
                        insertDetail.setItemId(insertTemp.getItemId());
                        itemWarehouseService.insertMdItemWarehouse(insertDetail);
                    });
                }
            }
        });
        //存在数据续断抓取，直到所有数据更新完成
        if(list.size()==1000){
            this.syncAddErpData();
        }
    }

    @Transactional
    public void syncEditErpData(){
        MdItemErpQuery itemErpQuery = new MdItemErpQuery();
        //获取最晚修改时间
        Date maxErpUpdateTime = mdItemMapper.maxErpUpdateTime();
        if(maxErpUpdateTime==null){
            Calendar curr = Calendar.getInstance();
            curr.set(Calendar.YEAR, 2000);
            maxErpUpdateTime = curr.getTime();
        }
        ErpPageParams.Sort sort = new ErpPageParams.Sort(){{
            List<ErpPageParams.Order> orders = new ArrayList<>();
            orders.add(new ErpPageParams.Order("modiDate","asc"));
            this.setOrders(orders);
        }};
        itemErpQuery.setSort(sort);
        itemErpQuery.setGtEqModiDate(maxErpUpdateTime);
        itemErpQuery.setCurrent(1);
        itemErpQuery.setPageSize(1000);//每次抓取1000行
        List<MdItemErpDto> list = erpService.getItemList(itemErpQuery).getData();
        list.forEach(s->{
            List<MdItem> dbList = mdItemMapper.selectMdItemByCode(s.getItemCode());
            if(dbList.size()==0) {
                if ("Y".equalsIgnoreCase(s.getVerifyStatus())) {
                    MdItem insertTemp = BeanUtil.toBean(s, MdItem.class);
                    this.insertMdItem(insertTemp);
                }
            }else{
                BeanUtil.copyProperties(s, dbList.get(0));
                if(!"Y".equalsIgnoreCase(s.getVerifyStatus())){
                    dbList.get(0).setEnableFlag("N");
                }
                this.updateMdItem(dbList.get(0));
            }
            //更新库房明细
            List<MdItemWarehouseErpDto> detailList = s.getWarehouseList();
            MdItemWarehouse itemWarehouseQuery = new MdItemWarehouse();
            itemWarehouseQuery.setItemCode(s.getItemCode());
            List<MdItemWarehouseDto> detailDblist = itemWarehouseService.selectMdItemWarehouseList(itemWarehouseQuery);
            detailList.forEach(s2->{
                java.util.Optional<MdItemWarehouseDto> itemWarehouseDto = detailDblist.stream().filter(temp->temp.getWarehouseCode().equals(s2.getWarehouseCode())).findFirst();
                if(itemWarehouseDto.isPresent()){
                    MdItemWarehouseUpdate updateDetail = BeanUtil.toBean(itemWarehouseDto.get(), MdItemWarehouseUpdate.class);
                    BeanUtil.copyProperties(s2, updateDetail);
                    itemWarehouseService.updateMdItemWarehouse(updateDetail);
                }else {
                    MdItemWarehouseCreate insertDetail = BeanUtil.toBeanIgnoreError(s2, MdItemWarehouseCreate.class);
                    itemWarehouseService.insertMdItemWarehouse(insertDetail);
                }
            });
        });
        //存在数据续断抓取，直到所有数据更新完成
        if(list.size()==1000){
            this.syncEditErpData();
        }
    }
}
