package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.mes.md.domain.MdSapField;
import com.ximai.mes.md.vo.SapFieldVo;

import java.util.List;
import java.util.Map;
/**
 * Sap特性视图Service接口
 *
 * @author generator
 * @date 2024-01-31
 */
public interface IMdSapFieldService extends IService<MdSapField> {

    /**
     * 分页查询
     *
     * @param params 分页参数
     * @return 分页结果
     */
    TableDataInfo page(Map<String, Object> params);

    /**
     * 查询Sap特性视图
     *
     *
     * @param params
     */
    MdSapField getOne(Map<String, Object> params);

    /**
     * 查询Sap特性视图列表
     *
     *
     * @param params@return Sap特性视图集合
     */
    List<MdSapField> selectList(Map<String, Object> params);

    List<SapFieldVo> listVo(Map<String, Object> params);

    /**
     * 新增Sap特性视图
     *
     * @param mdSapField Sap特性视图
     * @return 结果
     */
    Boolean insert(MdSapField mdSapField);

    /**
     * 修改Sap特性视图
     *
     * @param mdSapField Sap特性视图
     * @return 结果
     */
    Boolean update(MdSapField mdSapField);

    /**
     * 批量删除Sap特性视图
     *
     * @param ids 需要删除的Sap特性视图主键集合
     * @return 结果
     */
    Boolean deleteByIds(List<Long> ids);

    /**
     * 删除Sap特性视图信息
     *
     * @param id Sap特性视图主键
     * @return 结果
     */
    Boolean deleteById(Long id);
}
