package com.ximai.mes.md.service;

import com.ximai.common.core.domain.TreeSelect;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.mes.md.vo.MdItemTypeVo;

import java.util.List;

public interface IItemTypeService {

    List<MdItemType> selectItemTypeList(MdItemType mdItemType);

    MdItemType selectItemTypeById(Long itemTypeId);

    MdItemType selectItemTypeByItemTypeName(String itemTypeName);

    List<TreeSelect> buildTreeSelect(List<MdItemType> list);

    String checkItemTypeCodeUnique(MdItemType mdItemType);

    String checkItemTypeNameUnique(MdItemType mdItemType);

    Integer insertItemType(MdItemType mdItemType);

    Integer updateItemType(MdItemType mdItemType);

    Integer removeItemType(Long itemTypeId);

    boolean checkHasChild(Long itemTypeId);

    boolean checkHasItem(Long itemTypeId);

    void synchroItemType(List<MdItemTypeVo> mdItemTypeVos);
}
