package com.ximai.mes.md.mapper;

import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.vo.MdBaseInfoVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 产品基本信息Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface MdBaseInfoMapper
{
    /**
     * 查询产品基本信息
     *
     * @param itemId 产品基本信息主键
     * @return 产品基本信息
     */
    public MdBaseInfoVo selectMdBaseInfoByItemId(Long itemId);


    @Select("select *from md_base_info where item_id=#{itemId} ")
    public MdBaseInfo selectMdBaseInfoByItemIds(@Param("itemId") Long itemId);

    /**
     * 新增产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    public int insertMdBaseInfo(MdBaseInfo mdBaseInfo);





    /**
     * 修改产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    public int updateMdBaseInfo(MdBaseInfo mdBaseInfo);

    /**
     * 删除产品基本信息
     *
     * @param itemId 产品基本信息主键
     * @return 结果
     */
    public int deleteMdBaseInfoByItemId(Long itemId);

}
