package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 客户对象 md_client
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Getter
@Setter
@ToString
public class MdClientExcelExport {

    /**
     * 客户编码
     */
    @ExcelProperty("客户编码")
    private String clientCode;

    /**
     * sap客户编码
     */
    @ExcelProperty("sap客户编码")
    private String sapClientCode;

    /**
     * 客户名称
     */
    @ExcelProperty("客户名称")
    private String clientName;

    /**
     * 客户简称
     */
    @ExcelProperty("客户简称")
    private String clientNick;

    /**
     * 客户英文名称
     */
    @ExcelProperty("客户英文名称")
    private String clientEn;

    /**
     * 英文名简称
     */
    @ExcelProperty("英文名简称")
    private String clientEnAbbr;

    /**
     * 客户等级
     */
    @ExcelProperty("客户等级")
    private Long clientLevel;

    /**
     * 做账难度等级
     */
    @ExcelProperty("做账难度等级")
    private Long billLevel;

    /**
     * 开票地址
     */
    @ExcelProperty("开票地址")
    private String invoiceAddr;

    /**
     * 客户送货地址
     */
    @ExcelProperty("客户送货地址")
    private String address;

    /**
     * 所属地区
     */
    @ExcelProperty("所属地区")
    private String region;

    /**
     * 国家
     */
    @ExcelProperty("国家")
    private String country;

    /**
     * 城市
     */
    @ExcelProperty("城市")
    private String city;

    /**
     * 地区
     */
    @ExcelProperty("地区")
    private String area;

    /**
     * 语言
     */
    @ExcelProperty("语言")
    private String lang;

    /**
     * 邮政编码
     */
    @ExcelProperty("邮政编码")
    private String postcode;

    /**
     * 电话号码
     */
    @ExcelProperty("电话号码")
    private String tel;

    /**
     * 移动电话
     */
    @ExcelProperty("移动电话")
    private String phone;

    /**
     * email
     */
    @ExcelProperty("email")
    private String email;

    /**
     * 要求用客户系统货单
     */
    @ExcelProperty("要求用客户系统货单")
    private String isClientWaybill;

    /**
     * 盖章方式
     */
    @ExcelProperty("盖章方式")
    private String stampMode;

    /**
     * 请款联
     */
    @ExcelProperty("请款联")
    private String requisition;

    /**
     * 客户联
     */
    @ExcelProperty("客户联")
    private String clientForm;

    /**
     * 订单要求
     */
    @ExcelProperty("订单要求")
    private String orderRequest;

    /**
     * 验收单要求
     */
    @ExcelProperty("验收单要求")
    private String receiptRequest;

    /**
     * 客户系统验收要求
     */
    @ExcelProperty("客户系统验收要求")
    private String clientCheckRequest;

    /**
     * 要求签回货单
     */
    @ExcelProperty("要求签回货单")
    private String requestSignReceipt;

    /**
     * 货单是否打印送货日期
     */
    @ExcelProperty("货单是否打印送货日期")
    private String isPrintDate;

    /**
     * 不开发票
     */
    @ExcelProperty("不开发票")
    private String noInvoice;

    /**
     * 请款要求
     */
    @ExcelProperty("请款要求")
    private String paymentRequest;

    /**
     * 客户工作时间
     */
    @ExcelProperty("客户工作时间")
    private String clientWorkTime;

    /**
     * 收货方签字要求
     */
    @ExcelProperty("收货方签字要求")
    private String signRequest;

    /**
     * 货单打印要求
     */
    @ExcelProperty("货单打印要求")
    private String billPrintRequest;

    /**
     * 所属集团
     */
    @ExcelProperty("所属集团")
    private String membershipGroup;

    /**
     * 产品检验报告类型
     */
    @ExcelProperty("产品检验报告类型")
    private String qcReportType;

    /**
     * 货单签回方式
     */
    @ExcelProperty("货单签回方式")
    private String receiptSigningMethod;

    /**
     * 出货方式
     */
    @ExcelProperty("出货方式")
    private String shippingMethod;

    /**
     * 线路
     */
    @ExcelProperty("线路")
    private String path;

    /**
     * 送货单打印默认设置
     */
    @ExcelProperty("送货单打印默认设置")
    private String billPrintSetting;

    /**
     * 送货单统计异常期限
     */
    @ExcelProperty("送货单统计异常期限")
    private String billExceptionDeadline;

    /**
     * 生产发货方式
     */
    @ExcelProperty("生产发货方式")
    private String sendMode;

    /**
     * 月结方式（金库查询结算方式）
     */
    @ExcelProperty("月结方式")
    private String settleMode;

    /**
     * 请款期限
     */
    @ExcelProperty("请款期限")
    private String paymentDeadline;

    /**
     * 做账截止日
     */
    @ExcelProperty("做账截止日")
    private String accountingDeadline;

    /**
     * 客户收账截止日
     */
    @ExcelProperty("客户收账截止日")
    private String collectionDeadline;

    /**
     * 订单统计异常期限
     */
    @ExcelProperty("订单统计异常期限")
    private String orderExceptionDeadline;

    /**
     * 扣款百分比
     */
    @ExcelProperty("扣款百分比")
    private String deductionPercent;

    /**
     * 金额小数位数
     */
    @ExcelProperty("金额小数位数")
    private String amountDecimal;

    /**
     * 公司法人
     */
    @ExcelProperty("公司法人")
    private String legalPerson;

    /**
     * 工商注册号
     */
    @ExcelProperty("工商注册号")
    private String licenseNo;

    /**
     * 国税注册号
     */
    @ExcelProperty("国税注册号")
    private String taxNo;

    /**
     * 订单性质
     */
    @ExcelProperty("订单性质")
    private String orderKind;

    /**
     * 是否启用
     */
    @ExcelProperty("是否启用")
    private String enableFlag;

}
