package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 尺码组明细对象 md_size_group_item
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public class MdSizeGroupItem extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 尺码组明细ID */
    private Long sizeGroupItemId;

    /** 尺码组ID */
    @Excel(name = "尺码组ID")
    private Long sizeGroupId;

    /** 尺码组明细序号 */
    @Excel(name = "尺码组明细序号")
    private Long sizeIndex;

    /** 尺码名称 */
    @Excel(name = "尺码名称")
    private String sizeName;

    /** 显示名称 */
    @Excel(name = "显示名称")
    private String sizeDisplayName;

    public void setSizeGroupItemId(Long sizeGroupItemId)
    {
        this.sizeGroupItemId = sizeGroupItemId;
    }

    public Long getSizeGroupItemId()
    {
        return sizeGroupItemId;
    }
    public void setSizeGroupId(Long sizeGroupId)
    {
        this.sizeGroupId = sizeGroupId;
    }

    public Long getSizeGroupId()
    {
        return sizeGroupId;
    }
    public void setSizeIndex(Long sizeIndex)
    {
        this.sizeIndex = sizeIndex;
    }

    public Long getSizeIndex()
    {
        return sizeIndex;
    }
    public void setSizeName(String sizeName)
    {
        this.sizeName = sizeName;
    }

    public String getSizeName()
    {
        return sizeName;
    }
    public void setSizeDisplayName(String sizeDisplayName)
    {
        this.sizeDisplayName = sizeDisplayName;
    }

    public String getSizeDisplayName()
    {
        return sizeDisplayName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("sizeGroupItemId", getSizeGroupItemId())
            .append("sizeGroupId", getSizeGroupId())
            .append("sizeIndex", getSizeIndex())
            .append("sizeName", getSizeName())
            .append("sizeDisplayName", getSizeDisplayName())
            .append("remark", getRemark())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
