package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.vo.SapFieldVo;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import com.ximai.mes.md.domain.MdSapField;
import com.ximai.mes.md.service.IMdSapFieldService;

/**
 * Sap特性视图Controller
 *
 * @author generator
 * @date 2024-01-31
 */
@RestController
@AllArgsConstructor
@RequestMapping("/md/mdSapField")
public class MdSapFieldController {

    private final IMdSapFieldService mdSapFieldService;

    /**
     * 查询客户产品对照列表
     */
    @PostMapping("/page")
    @PreAuthorize("@ss.hasPermi('md:mdSapField:list')")
    public AjaxResult page(@RequestBody Map<String, Object> params) {
        final TableDataInfo page = mdSapFieldService.page(params);
        return AjaxResult.success(page);
    }

    /**
     * 查询Sap特性视图列表
     */
    @GetMapping("/list")
    @PreAuthorize("@ss.hasPermi('md:mdSapField:list')")
    public AjaxResult list(@RequestParam Map<String, Object> params) {
        List<MdSapField> list = mdSapFieldService.selectList(params);
        return AjaxResult.success(list);
    }

    /**
     * 查询Sap特性视图列表
     */
    @GetMapping("/listVo")
    @PreAuthorize("@ss.hasPermi('md:mdSapField:list')")
    public AjaxResult listVo(@RequestParam Map<String, Object> params) {
        List<SapFieldVo> list = mdSapFieldService.listVo(params);
        return AjaxResult.success(list);
    }
    /**
     * 获取Sap特性视图详细信息
     */
    @GetMapping
    @PreAuthorize("@ss.hasPermi('md:mdSapField:query')")
    public AjaxResult get(@RequestParam Map<String, Object> params) {
        return AjaxResult.success(mdSapFieldService.getOne(params));
    }

    /**
     * 新增Sap特性视图
     */
    @PostMapping
    @PreAuthorize("@ss.hasPermi('md:mdSapField:add')")
    @Log(title = "Sap特性视图", businessType = BusinessType.INSERT)
    public AjaxResult add(@RequestBody MdSapField mdSapField) {
        return mdSapFieldService.insert(mdSapField) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 修改Sap特性视图
     */
    @PutMapping
    @PreAuthorize("@ss.hasPermi('md:mdSapField:edit')")
    @Log(title = "Sap特性视图", businessType = BusinessType.UPDATE)
    public AjaxResult edit(@RequestBody MdSapField mdSapField) {
        return mdSapFieldService.update(mdSapField) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 删除Sap特性视图
     */
    @DeleteMapping("/{ids}")
    @PreAuthorize("@ss.hasPermi('md:mdSapField:remove')")
    @Log(title = "Sap特性视图", businessType = BusinessType.DELETE)
    public AjaxResult remove(@PathVariable List<Long> ids) {
        return mdSapFieldService.deleteByIds(ids) ? AjaxResult.success() : AjaxResult.error();
    }
}
