package com.ximai.mes.constant;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum WorkorderStatusEnum {

    /**
     * 待发布
     */
    PREPARE("PREPARE"),
    /**
     * 已发布
     */
    PUBLISHED("PUBLISHED"),
    /**
     * 已组合
     */
    COMBINED("COMBINED"),
    /**
     * 已编排
     */
    ORCHESTRATED("ORCHESTRATED"),
    /**
     * 已排产
     */
    SCHEDULED("SCHEDULED"),
    /**
     * 已完成
     */
    FINISHED("FINISHED"),
    /**
     * 已取消
     */
    CANCELED("CANCELED"),
    /**
     * 暂停
     */
    STOPPAGE("STOPPAGE"),
    /**
     * 锁定
     */
    LOCK("LOCK"),
    /**
     * 已下达
     */
    ISSUED("ISSUED"),
    /**
     * 关闭/取消
     */
    CLOSE("CLOSE"),
    CANCEL("CANCEL"),
    /**
     * 生产中
     */
    PRODUCING("PRODUCING");

    /**
     * Lock type
     */
    private final String status;

    /**
     * Constructor with field of type
     */
    private WorkorderStatusEnum(String status) {
        this.status = status;
    }

    public String getValue() {
        return status;
    }


    public static WorkorderStatusEnum get(String value) {
        for (WorkorderStatusEnum temp : WorkorderStatusEnum.values()) {
            if (temp.getValue().equals(value)) {
                return temp;
            }
        }
        return null;
    }
}
