package com.ximai.common.core.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.annotation.Excel.Type;
import com.ximai.common.annotation.Excels;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.core.domain.BaseExcelImport;
import com.ximai.common.core.domain.entity.SysDept;
import com.ximai.common.core.domain.entity.SysRole;
import com.ximai.common.utils.excel.I18nField;
import com.ximai.common.utils.excel.converter.LocalDateTimeConverter;
import com.ximai.common.xss.Xss;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 用户对象 sys_user
 */
@Data
@ApiModel("用户导入")
public class SysUserExcelImport extends BaseExcelImport {

    /**
     * 部门ID
     */
    @ExcelProperty("部门编号")
    @I18nField("user.jcaptcha.error2")
    private Long deptId;

    /**
     * 用户账号
     */
    @ExcelProperty("登录名称")
    @I18nField("user.userName")
    private String userName;

    /**
     * 用户昵称
     */
    @ExcelProperty("用户名称")
    @I18nField("user.nickName")
    private String nickName;

    /**
     * 用户邮箱
     */
    @ExcelProperty("用户邮箱")
    @I18nField("user.email")
    private String email;

    /**
     * 手机号码
     */
    @ExcelProperty("手机号码")
    @I18nField("user.phonenumber")
    private String phonenumber;

    /**
     * 用户性别
     */
    @ExcelProperty("用户性别")
    private String sex;

    /**
     * 帐号状态（0正常 1停用）
     */
    @ExcelProperty("帐号状态")
    private String status;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    private String delFlag;

    /**
     * 最后登录IP
     */
    @ExcelProperty("最后登录IP")
    private String loginIp;

    /**
     * 最后登录时间
     */
    @ExcelProperty(value = "最后登录时间",  converter = LocalDateTimeConverter.class)
    private Date loginDate;

    @ApiModelProperty("国际化语言")
    private String locale;
}
