package com.ximai.common.core.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 字典数据表 sys_dict_data
 */
@Data
@ApiModel("字典数据导出")
public class SysDictDataExcelExport {
    private static final long serialVersionUID = 1L;

    /**
     * 字典编码
     */
    @ExcelProperty("字典编码")
    private Long dictCode;

    /**
     * 字典排序
     */
    @ExcelProperty("字典排序")
    private Long dictSort;

    /**
     * 字典标签
     */
    @ExcelProperty("字典标签")
    private String dictLabel;

    /**
     * 字典键值
     */
    @ExcelProperty("字典键值")
    private String dictValue;

    /**
     * 字典类型
     */
    @ExcelProperty("字典类型")
    private String dictType;

    /**
     * 是否默认（Y是 N否）
     */
    @ExcelProperty("是否默认")
    private String isDefault;

    /**
     * 状态（0正常 1停用）
     */
    @ExcelProperty("状态")
    private String status;

}
