package com.ximai.mes.tm.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * 工装夹具类型对象 tm_tool_type
 *
 * @date 2022-05-10
 */
@Data
public class TmToolType extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 类型ID
     */
    private Long toolTypeId;

    private List<String> toolTypecodes;
    /**
     * 类型编码
     */
    @Excel(name = "类型编码")
    private String toolTypeCode;

    /**
     * 类型名称
     */
    @Excel(name = "类型名称")
    private String toolTypeName;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String codeFlag;

    /**
     * 保养维护类型
     */
    @Excel(name = "保养维护类型")
    private String maintenType;

    /**
     * 保养周期
     */
    @Excel(name = "保养周期")
    private Long maintenPeriod;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

}
