package com.ximai.mes.qc.controller;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.excel.ExcelWriter;
import com.ximai.mes.qc.dto.QcAbnormalInformationExcelExport;
import com.ximai.mes.qc.mapper.QcAbnormalInformationMapper;
import org.dom4j.tree.BackedList;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.qc.domain.QcAbnormalInformation;
import com.ximai.mes.qc.service.IQcAbnormalInformationService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 异常信息Controller
 *
 * @author generator
 * @date 2024-02-19
 */
@RestController
@RequestMapping("/qc/information")
public class QcAbnormalInformationController extends BaseController
{
    @Autowired
    private IQcAbnormalInformationService qcAbnormalInformationService;

    @Autowired
    private QcAbnormalInformationMapper qcAbnormalInformationMapper;
    /**
     * 查询异常信息列表
     */
    @PreAuthorize("@ss.hasPermi('qc:information:list')")
    @GetMapping("/list")
    public TableDataInfo list(QcAbnormalInformation qcAbnormalInformation)
    {
        startPage();
        List<QcAbnormalInformation> list = qcAbnormalInformationService.selectQcAbnormalInformationList(qcAbnormalInformation);
        return getDataTable(list);
    }

    /**
     * 获取异常信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('qc:information:query')")
    @GetMapping(value = "/{abnormalId}")
    public AjaxResult getInfo(@PathVariable("abnormalId") Long abnormalId)
    {
        return AjaxResult.success(qcAbnormalInformationService.selectQcAbnormalInformationByAbnormalId(abnormalId));
    }

    /**
     * 新增异常信息
     */
    @PreAuthorize("@ss.hasPermi('qc:information:add')")
    @Log(title = "异常信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody QcAbnormalInformation qcAbnormalInformation)
    {
//        List<QcAbnormalInformation> qcAbnormalInformations = qcAbnormalInformationMapper.selectQcAbnormalInformationList(qcAbnormalInformation);
//        for(QcAbnormalInformation qcAbnormal:qcAbnormalInformations){
//            if(qcAbnormal.getAbnormalReason().equals(qcAbnormalInformation.getAbnormalReason())){
//                   return AjaxResult.error("异常原因不能重复");
//            }
//        }
        return toAjax(qcAbnormalInformationService.insertQcAbnormalInformation(qcAbnormalInformation));
    }

    /**
     * 修改异常信息
     */
    @PreAuthorize("@ss.hasPermi('qc:information:edit')")
    @Log(title = "异常信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody QcAbnormalInformation qcAbnormalInformation)
    {
        return toAjax(qcAbnormalInformationService.updateQcAbnormalInformation(qcAbnormalInformation));
    }

    /**
     * 删除异常信息
     */
    @PreAuthorize("@ss.hasPermi('qc:information:remove')")
    @Log(title = "异常信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{abnormalIds}")
    public AjaxResult remove(@PathVariable Long[] abnormalIds)
    {
        return toAjax(qcAbnormalInformationService.deleteQcAbnormalInformationByAbnormalIds(abnormalIds));
    }

    /**
     * 导出异常信息列表
     */
    @PreAuthorize("@ss.hasPermi('qc:information:export')")
    @Log(title = "异常信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, QcAbnormalInformation qcAbnormalInformation) throws IOException {
        List<QcAbnormalInformation> list = qcAbnormalInformationService.selectQcAbnormalInformationList(qcAbnormalInformation);
        List<QcAbnormalInformationExcelExport> exportList = BeanUtil.copyToList(list, QcAbnormalInformationExcelExport.class);
        ExcelWriter.write(response, QcAbnormalInformationExcelExport.class, exportList);
    }
}
