package com.ximai.mes.pro.service;

import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.ProStartWork;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.qc.domain.QcAbnormalReport;

import java.util.List;

/**
 * 开始作业记录表Service接口
 *
 * @author generator
 * @date 2024-03-11
 */
public interface IProStartWorkService {
    /**
     * 查询开始作业记录表
     *
     * @param startWorkId 开始作业记录表主键
     * @return 开始作业记录表
     */
    ProStartWork selectProStartWorkByStartWorkId(Long startWorkId);

    /**
     * 查询开始作业记录表列表
     *
     * @param proStartWork 开始作业记录表
     * @return 开始作业记录表集合
     */
    List<ProStartWork> selectProStartWorkList(ProStartWork proStartWork);

    /**
     * 新增开始作业记录表
     *
     * @param proStartWork 开始作业记录表
     * @return 结果
     */
    int insertProStartWork(ProStartWork proStartWork);

    /**
     * 修改开始作业记录表
     *
     * @param proStartWork 开始作业记录表
     * @return 结果
     */
    int updateProStartWork(ProStartWork proStartWork);

    /**
     * 批量删除开始作业记录表
     *
     * @param startWorkIds 需要删除的开始作业记录表主键集合
     * @return 结果
     */
    int deleteProStartWorkByStartWorkIds(Long[] startWorkIds);

    /**
     * 删除开始作业记录表信息
     *
     * @param startWorkId 开始作业记录表主键
     * @return 结果
     */
    int deleteProStartWorkByStartWorkId(Long startWorkId);


    void insertObj(ProTask proTask);


    List<ProStartWork> selectListByTwId(Long taskWorkunitId);

    void updateObj(QcAbnormalReport qcAbnormalReport);

    void updateObj(ProFeedback proFeedback);

    void closeObj(ProFeedback proFeedback);


    void updateObj(ProTask proTask);

}
