package com.ximai.mes.pro.mapper.productionRequest;

import java.util.List;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequest;
import org.apache.ibatis.annotations.Param;

/**
 * 量产申请Mapper接口
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
public interface ProProductionRequestMapper
{
    /**
     * 查询量产申请
     *
     * @param productionRequestId 量产申请主键
     * @return 量产申请
     */
    public ProProductionRequest selectProProductionRequestByProductionRequestId(Long productionRequestId);

    /**
     * 查询量产申请列表
     *
     * @param proProductionRequest 量产申请
     * @return 量产申请集合
     */
    public List<ProProductionRequest> selectProProductionRequestList(ProProductionRequest proProductionRequest);


    public List<ProProductionRequest> selectProProductionRequestListJoin(ProProductionRequest proProductionRequest);

    /**
     * 新增量产申请
     *
     * @param proProductionRequest 量产申请
     * @return 结果
     */
    public int insertProProductionRequest(ProProductionRequest proProductionRequest);

    /**
     * 修改量产申请
     *
     * @param proProductionRequest 量产申请
     * @return 结果
     */
    public int updateProProductionRequest(ProProductionRequest proProductionRequest);

    /**
     * 删除量产申请
     *
     * @param productionRequestId 量产申请主键
     * @return 结果
     */
    public int deleteProProductionRequestByProductionRequestId(Long productionRequestId);

    /**
     * 批量删除量产申请
     *
     * @param productionRequestIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionRequestByProductionRequestIds(Long[] productionRequestIds);

    public int updateProProductionRequestStatus(@Param("productionRequestId") Long productionRequestId, @Param("productionRequestStatus") int productionRequestStatus);
}
