package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ProMaterialRequestVo extends BaseEntity {

    private static final long serialVersionUID = -8928452144113403131L;
    @TableId
    private Long materialRequestId;

    /**
     * 申请号
     */
    @Excel(name = "申请号")
    private String applyNo;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private Long itemId;




    /**
     * 任务单ID
     */
    @Excel(name = "任务单ID")
    private Long taskId;

    private Long taskWorkunitId;
    /**
     * 工单Id
     */
    @Excel(name = "工单ID")
    private Long workorderId;


    /**
     * 工单号
     */
    @Excel(name = "工单号")
    private String workorderCode;


    /**
     * 预留相关需求的编号
     */
    @Excel(name = "预留相关需求的编号")
    private String requirementNumber;


    /**
     * 预留相关需求的项目编号
     */
    @Excel(name = "预留相关需求的项目编号")
    private String requirementProjectNumber;


    /**
     * 领料类型
     */
    @Excel(name = "领料类型")
    private Long materialType;


    /**
     * 领料原因
     */
    @Excel(name = "领料原因")
    private String pickingReason;



    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long processId;

    /**
     * 申请数量
     */
    @Excel(name = "申请数量")
    private BigDecimal applyNum;

    /**
     * 申请类型
     */
    @Excel(name = "申请类型")
    private Integer applyType;

    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String batchNumber;


    /**
     * 产品编码
     */
    @Excel(name = "产品编码")
    private String itemCode;


    /**
     * 产品名称
     */
    @Excel(name = "产品名称")
    private String itemName;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private String sapItemCode;


    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String arrangeCode;


    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1")
    private String attr1;

    /**
     * 预留字段2
     */
    @Excel(name = "预留字段2")
    private String attr2;

    /**
     * 预留字段3
     */
    @Excel(name = "预留字段3")
    private Integer attr3;

    /**
     * 预留字段4
     */
    @Excel(name = "预留字段4")
    private Integer attr4;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Long workunitId;
    private String workunitName;
    private String workunitCode;

    //打印时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "打印时间")
    private Date printTime;

    //序列号
    @Excel(name = "序列号")
    private String serialNumber;

    /**
     * 工作中心编号
     */
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    private String workstationName;


    /** 车间编码 */
    @Excel(name = "车间编码")
    private String workshopCode;

    /** 车间名称 */
    @Excel(name = "车间名称")
    private String workshopName;
    /**
     * 是的结案
     */
    @Excel(name = "是否结案")
    private String windCase;

    /**
     * 已发放数量
     */
    @Excel(name = "已发放数量")
    private BigDecimal grantNum;

}
