package com.ximai.mes.pro.domain.proWorkOrder;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 生产工单尺码对象 pro_work_order_so_size_item
 *
 * @author zht
 * @date 2024-02-29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderSoSizeItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId
    private Long workorderSoSizeItemId;

    /**
     * 工单ID
     */
    @Excel(name = "工单ID")
    private Long workorderId;


    private String workorderCode;

    /**
     * 销售订单号
     */
    private Long salesId;

    /**
     * 销售订单行项目
     */
    private String salesItem;

    /**
     * 销售订单指令号
     */
    private String clientCmd;

    /**
     * loss数
     */
    private BigDecimal lossNum;

    /**
     * 派工倍数
     */
    private BigDecimal dispatchMultiple;
    /**
     * 序号
     */
    @Excel(name = "序号")
    private String idx;

    /**
     * 品牌
     */
    @Excel(name = "品牌")
    private String brandCode;

    /**
     * 销线
     */
    @Excel(name = "销线")
    private String salePath;

    /**
     * SIZE类型组
     */
    @Excel(name = "SIZE类型组")
    private String sizeType;

    /**
     * 产品类别
     */
    @Excel(name = "产品类别")
    private String itemType;

    /**
     * 段别
     */
    @Excel(name = "段别")
    private String segment;

    /**
     * 季度
     */
    @Excel(name = "季度")
    private String quarter;

    /**
     * 特殊Size
     */
    @Excel(name = "特殊Size")
    private String specSize;

    /**
     * 整/半码
     */
    @Excel(name = "整/半码")
    private String wholeSize;

    /**
     * 产品规格
     */
    @Excel(name = "产品规格")
    private String prodSpec;

    /**
     * 标准SIZE类型
     */
    @Excel(name = "标准SIZE类型")
    private String standardSizeType;

    /**
     * USA
     */
    @Excel(name = "USA")
    private String usa;

    /**
     * UK
     */
    @Excel(name = "UK")
    private String uk;

    /**
     * RUS
     */
    @Excel(name = "RUS")
    private String pus;

    /**
     * JAN
     */
    @Excel(name = "JAN")
    private String jan;

    /**
     * THA
     */
    @Excel(name = "THA")
    private String tha;

    /**
     * CHN
     */
    @Excel(name = "CHN")
    private String chn;

    /**
     * IND
     */
    @Excel(name = "IND")
    private String ind;

    /**
     * KKET
     */
    @Excel(name = "KKET")
    private String kket;

    /**
     * US
     */
    @Excel(name = "US")
    private String us;

    /**
     * EU
     */
    @Excel(name = "EU")
    private String eu;

    /**
     * JP
     */
    @Excel(name = "JP")
    private String jp;

    /**
     * MM
     */
    @Excel(name = "MM")
    private String mm;

    /**
     * BRA
     */
    @Excel(name = "BRA")
    private String bra;

    /**
     * EUR
     */
    @Excel(name = "EUR")
    private String eur;

    /**
     * CM
     */
    @Excel(name = "CM")
    private String cm;

    /**
     * U
     */
    @Excel(name = "U")
    private String u;

    /**
     * MX
     */
    @Excel(name = "MX")
    private String mx;

    /**
     * CHI
     */
    @Excel(name = "CHI")
    private String chi;

    /**
     * JAP
     */
    @Excel(name = "JAP")
    private String jap;

    /**
     * JAPAN
     */
    @Excel(name = "JAPAN")
    private String japan;

    /**
     * MEX
     */
    @Excel(name = "MEX")
    private String mex;

    /**
     * METRIC
     */
    @Excel(name = "METRIC")
    private String metric;

    /**
     * PACK
     */
    @Excel(name = "PACK")
    private String pack;

    /**
     * USM
     */
    @Excel(name = "USM")
    private String usm;

    /**
     * USW
     */
    @Excel(name = "USW")
    private String usw;

    /**
     * KX
     */
    @Excel(name = "KX")
    private String kx;

    /**
     * AU
     */
    @Excel(name = "AU")
    private String au;

    /**
     * CN
     */
    @Excel(name = "CN")
    private String cn;

    /**
     * EURO
     */
    @Excel(name = "EURO")
    private String euro;

    /**
     * GEN
     */
    @Excel(name = "GEN")
    private String gen;

    /**
     * JPN-Y
     */
    @Excel(name = "JPN-Y")
    private String jpnY;

    /**
     * JPN
     */
    @Excel(name = "JPN")
    private String jpn;

    /**
     * UKM
     */
    @Excel(name = "UKM")
    private String ukm;

    /**
     * UKW
     */
    @Excel(name = "UKW")
    private String ukw;

    /**
     * EUM
     */
    @Excel(name = "EUM")
    private String eum;

    /**
     * EUW
     */
    @Excel(name = "EUW")
    private String euw;

    /**
     * JAPM
     */
    @Excel(name = "JAPM")
    private String japm;

    /**
     * JAPW
     */
    @Excel(name = "JAPW")
    private String japw;

    /**
     * BR
     */
    @Excel(name = "BR")
    private String br;

    /**
     * USF
     */
    @Excel(name = "USF")
    private String usf;

    /**
     * FOOT
     */
    @Excel(name = "FOOT")
    private String foot;

    /**
     * 鞋内长
     */
    @Excel(name = "鞋内长")
    private String shoeInnerLength;

    /**
     * KOR
     */
    @Excel(name = "KOR")
    private String kor;

    /**
     * XX
     */
    @Excel(name = "XX")
    private String xx;

    /**
     * FR
     */
    @Excel(name = "FR")
    private String fr;

    /**
     * MULES
     */
    @Excel(name = "MULES")
    private String mules;

    /**
     * S
     */
    @Excel(name = "S")
    private String s;

    /**
     * XS
     */
    @Excel(name = "XS")
    private String xs;

    /**
     * M
     */
    @Excel(name = "M")
    private String m;

    /**
     * L
     */
    @Excel(name = "L")
    private String l;

    /**
     * XL
     */
    @Excel(name = "XL")
    private String xl;

    /**
     * XXL
     */
    @Excel(name = "XXL")
    private String xxl;

    /**
     * Re-fit
     */
    @Excel(name = "Re-fit")
    private String reFit;

    /**
     * JPN(CM)
     */
    @Excel(name = "JPN(CM)")
    private String jpnCm;

    /**
     * CMM
     */
    @Excel(name = "CMM")
    private String cmm;

    /**
     * CMW
     */
    @Excel(name = "CMW")
    private String cmw;

    /**
     * EURM
     */
    @Excel(name = "EURM")
    private String eurm;

    /**
     * EURW
     */
    @Excel(name = "EURW")
    private String eurw;

    /**
     * JPM
     */
    @Excel(name = "JPM")
    private String jpm;

    /**
     * JPW
     */
    @Excel(name = "JPW")
    private String jpw;

    /**
     * EOR
     */
    @Excel(name = "EOR")
    private String eor;

    /**
     * MO
     */
    @Excel(name = "MO")
    private String mo;

    /**
     * AUS
     */
    @Excel(name = "AUS")
    private String aus;

    /**
     * USL
     */
    @Excel(name = "USL")
    private String usl;

    /**
     * MEX(CM)
     */
    @Excel(name = "MEX(CM)")
    private String mexCm;

    /**
     * 码数
     */
    @Excel(name = "码数")
    private String size;

    /**
     * 鞋号
     */
    @Excel(name = "鞋号")
    private String shoeNum;

    /**
     * CAD
     */
    @Excel(name = "CAD")
    private String cad;

    /**
     * MONDO
     */
    @Excel(name = "MONDO")
    private String mondo;

    /**
     * ARG
     */
    @Excel(name = "ARG")
    private String arg;

    /**
     * US W’S
     */
    @Excel(name = "US W’S")
    private String usws;

    /**
     * M’S
     */
    @Excel(name = "M’S")
    private String ms;

    /**
     * 脚长
     */
    @Excel(name = "脚长")
    private String footLength;

    /**
     * 法码
     */
    @Excel(name = "法码")
    private String weights;

    /**
     * 鞋型
     */
    @Excel(name = "鞋型")
    private String shoeShape;

    /**
     * 楦型
     */
    @Excel(name = "楦型")
    private String lastShape;

    /**
     * UK/AU/NZ
     */
    @Excel(name = "UK/AU/NZ")
    private String ukAuNz;

    /**
     * RU
     */
    @Excel(name = "RU")
    private String ru;

    /**
     * UKAUNZ
     */
    @Excel(name = "UKAUNZ")
    private String unaunz;

    /**
     * NGG
     */
    @Excel(name = "NGG")
    private String ngg;

    /**
     * ENG
     */
    @Excel(name = "ENG")
    private String eng;

    /**
     * 韩年龄
     */
    @Excel(name = "韩年龄")
    private String koreaAge;

    /**
     * US1
     */
    @Excel(name = "US1")
    private String us1;

    /**
     * US2
     */
    @Excel(name = "US2")
    private String us2;

    /**
     * CHN&EU
     */
    @Excel(name = "CHN&EU")
    private String chnEu;

    /**
     * CM(JP)
     */
    @Excel(name = "CM(JP)")
    private String cmJp;

    /**
     * MONTHS
     */
    @Excel(name = "MONTHS")
    private String months;

    /**
     * CN(cm)
     */
    @Excel(name = "CN(cm)")
    private String cnCm;

    /**
     * DPS
     */
    @Excel(name = "DPS")
    private String dps;

    /**
     * NBJ
     */
    @Excel(name = "NBJ")
    private String nbj;

    /**
     * AR
     */
    @Excel(name = "AR")
    private String ar;

    /**
     * POR
     */
    @Excel(name = "POR")
    private String por;

    /**
     * Spain
     */
    @Excel(name = "Spain")
    private String spain;

    /**
     * MP
     */
    @Excel(name = "MP")
    private String mp;

    /**
     * UA
     */
    @Excel(name = "UA")
    private String ua;

    /**
     * CHNW
     */
    @Excel(name = "CHNW")
    private String chnw;

    /**
     * CHNM
     */
    @Excel(name = "CHNM")
    private String chnm;

    /**
     * US/CAN
     */
    @Excel(name = "US/CAN")
    private String usCan;

    /**
     * TYPE
     */
    @Excel(name = "TYPE")
    private String type;

    /**
     * USM/USW
     */
    @Excel(name = "USM/USW")
    private String usmUsw;

    /**
     * CAN
     */
    @Excel(name = "CAN")
    private String can;

    /**
     * ES
     */
    @Excel(name = "ES")
    private String es;

    /**
     * KR
     */
    @Excel(name = "KR")
    private String kr;

    @ApiModelProperty("要求数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    /**
     * 合格品数量
     */
    @ApiModelProperty("合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty("不良品数量")
    private BigDecimal quantityUnqualify;

    public String getStandardSize(){
        String column = SIZE_MAP_COLUMN.get(this.getStandardSizeType().toUpperCase());
        if (column != null) {
            String val = (String) BeanUtil.getFieldValue(this, column);
            if(val==null){
                val="";
            }
            return val;
        }
        return "";
    }

    private static Map<String,String> SIZE_MAP_COLUMN=new HashMap<String,String>(){
        {
            put("USA","usa");
            put("UK","uk");
            put("RUS","pus");
            put("JAN","jan");
            put("THA","tha");
            put("CHN","chn");
            put("IND","ind");
            put("KKET","kket");
            put("US","us");
            put("EU","eu");
            put("JP","jp");
            put("MM","mm");
            put("BRA","bra");
            put("EUR","eur");
            put("CM","cm");
            put("U","u");
            put("MX","mx");
            put("CHI","chi");
            put("JAP","jap");
            put("JAPAN","japan");
            put("MEX","mex");
            put("METRIC","metric");
            put("PACK","pack");
            put("USM","usm");
            put("USW","usw");
            put("KX","kx");
            put("AU","au");
            put("CN","cn");
            put("EURO","euro");
            put("GEN","gen");
            put("JPN-Y","jpnY");
            put("JPN","jpn");
            put("UKM","ukm");
            put("UKW","ukw");
            put("EUM","eum");
            put("EUW","euw");
            put("JAPM","japm");
            put("JAPW","japw");
            put("BR","br");
            put("USF","usf");
            put("FOOT","foot");
            put("鞋内长","shoeInnerLength");
            put("KOR","kor");
            put("XX","xx");
            put("FR","fr");
            put("MULES","mules");
            put("S","s");
            put("XS","xs");
            put("M","m");
            put("L","l");
            put("XL","xl");
            put("XXL","xxl");
            put("RE-FIT","reFit");
            put("JPN(CM)","jpnCm");
            put("CMM","cmm");
            put("CMW","cmw");
            put("EURM","eurm");
            put("EURW","eurw");
            put("JPM","jpm");
            put("JPW","jpw");
            put("EOR","eor");
            put("MO","mo");
            put("AUS","aus");
            put("USL","usl");
            put("MEX(CM)","mexCm");
            put("码数","size");
            put("鞋号","shoeNum");
            put("CAD","cad");
            put("MONDO","mondo");
            put("ARG","arg");
            put("US W’S","usws");
            put("M’S","ms");
            put("脚长","footLength");
            put("法码","weights");
            put("鞋型","shoeShape");
            put("楦型","lastShape");
            put("UK/AU/NZ","ukAuNz");
            put("RU","ru");
            put("UKAUNZ","unaunz");
            put("NGG","ngg");
            put("ENG","eng");
            put("韩年龄","koreaAge");
            put("US1","us1");
            put("US2","us2");
            put("CHN&EU","chnEu");
            put("CM(JP)","cmJp");
            put("MONTHS","months");
            put("CN(CM)","cnCm");
            put("DPS","dps");
            put("NBJ","nbj");
            put("AR","ar");
            put("POR","por");
            put("SPAIN","spain");
            put("MP","mp");
            put("UA","ua");
            put("CHNW","chnw");
            put("CHNM","chnm");
            put("US/CAN","usCan");
            put("TYPE","type");
            put("USM/USW","usmUsw");
            put("CAN","can");
            put("ES","es");
            put("KR","kr");
        }
    };

}
