package com.ximai.mes.pro.domain.ep;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.math.BigDecimal;

/**
 * title:
 * author:ZHT
 * date:2024/3/1
 * description:
 */
@Data
@AllArgsConstructor
//@NoArgsConstructor
//@JsonIgnoreProperties
public class EPDtoProWorkOrderSoDirective extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 指令号
     */
    @JSONField(name = "ZINSTNUM")
    private String clientCmd;

    /**
     * 派工数
     */
    @JSONField(name = "ZPDSL")
    private String dispatchMultiple;

    /**
     * LOSS数
     */
    @JSONField(name = "ZLOSSC")
    private String lossNum;

    /**
     * 销售凭证
     */
    @JSONField(name = "VBELN")
    private String salesVoucher;

    /**
     * 销售凭证项目
     */
    @JSONField(name = "POSNR")
    private String salesVoucherItem;

    /**
     * 客户编号
     */
    @JSONField(name = "KUNNR")
    private String clientCode;

    /**
     * 尺码组
     */
    @JSONField(name = "ZSIZEGROUP")
    private String sizeGroup;

    /**
     * 尺码单位（客户）
     */
    @JSONField(name = "ZSIZEUNITC")
    private String clientSizeUnit;

    /**
     * 型体号
     */
    @JSONField(name = "ZMOLD")
    private String typeNo;

    /**
     * 配色号
     */
    @JSONField(name = "ZMAPCOLOR")
    private String colorNo;

    /**
     * 颜色
     */
    @JSONField(name = "ZCLOLOR")
    private String color;

    /**
     * 销线
     */
    @JSONField(name = "ZSALEAREA")
    private String salePath;

    /**
     * 段别
     */
    @JSONField(name = "ZDUANBIE")
    private String segment;

    /**
     * 季度
     */
    @JSONField(name = "ZSEASON")
    private String quarter;

    /**
     * 整/半码
     */
    @JSONField(name = "ZTOTALSIZE")
    private String wholeSize;

    /**
     * 特殊SIZE
     */
    @JSONField(name = "ZSPECSIZE")
    private String specSize;

    /**
     * PO#
     */
    @JSONField(name = "ZCPONUM")
    private String poNo;

    /**
     * WIP#
     */
    @JSONField(name = "ZWIPNUM")
    private String wipNo;

    /**
     * 装箱数
     */
    @JSONField(name = "ZBOXQUAN")
    private String packingNum;

    /**
     * 产地
     */
    @JSONField(name = "ZORIGIN")
    private String region;

    /**
     * 周期
     */
    @JSONField(name = "ZCYCLE")
    private String cycle;

    /**
     * SK编号
     */
    @JSONField(name = "ZSKCODE")
    private String skNo;

    /**
     * 专利号 CHAR 50
     */
    @JSONField(name = "ZPATENTCODE")
    private String patentNo;

    /**
     * 材质描述
     */
    @JSONField(name = "ZMATERIALDES")
    private String materialDesc;

    /**
     * 签收人
     */
    @JSONField(name = "ZSIGNPERSON")
    private String signer;

    /**
     * SHIP TO ID
     */
    @JSONField(name = "ZSHIPID")
    private String shipToId;

    /**
     * 产品规格
     */
    @JSONField(name = "ZPRODSPEC")
    private String prodSpec;

    /**
     * 产品用途
     */
    @JSONField(name = "ZPRODUSAGE")
    private String prodUsage;

    /**
     * 厚度（丝）
     */
    @JSONField(name = "ZTHICK")
    private String thickness;


    /**
     * 工厂代号
     */
    @JSONField(name = "ZPLANTCODE")
    private String plantCode;

    /**
     * 采购组织
     */
    @JSONField(name = "EKORG")
    private String purchaseOrg;

    /**
     * 数量
     */
    @JSONField(name = "ZZLSL")
    private String quantity;

    /**
     * 数量
     */
    @JSONField(name = "KWMENG")
    private String quantity2;

    /**
     * 包装方式
     */
    @JSONField(name = "ZPACKINGMOT")
    private String packMode;

    /**
     * 印刷方向
     */
    @JSONField(name = "ZPRINTDIRECT")
    private String printingDirection;

    /**
     * 包装数量
     */
    @JSONField(name = "ZPACKREQUNUM")
    private BigDecimal packNum;

    /**
     * 包装类型
     */
    @JSONField(name = "ZPACKREQU")
    private String packType;

    /**
     * 包装单位
     */
    @JSONField(name = "ZPACKUNIT")
    private String packUnit;

    /**
     * LOSS
     */
    @JSONField(name = "ZLOSSPACK")
    private String lossPack;


    @JSONField(name = "ZSIZE")
    private String zsize;
}
