package com.ximai.mes.pro.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.mes.pro.domain.vo.ProAllocationItemList;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 领料申请对象 pro_material_request
 *
 * @author generator
 * @date 2024-02-22
 */
@Data
public class ProMaterialRequest extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    @TableId
    private Long materialRequestId;

    /**
     * 申请号
     */
    @Excel(name = "申请号")
    private String applyNo;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private Long itemId;

    /**
     * sap物料编码
     */
    @TableField(exist = false)
    private String sapItemCode;

    /**
     * 物料名称
     */
    @TableField(exist = false)
    private String itemName;

    /**
     * 领料类型
     */
    @Excel(name = "领料类型")
    private Long materialType;



    /**
     * 工作中心编号
     */
    @Excel(name = "工作中心编号")
    private String workstationCode;

    /**
     * 工作中心ID
     */
    @Excel(name = "工作中心ID")
    private Long workstationId;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    private String workstationName;


    /**
     * 领料原因
     */
    @Excel(name = "领料原因")
    private String pickingReason;

    @TableField(exist = false)
    private String reason;



    /**
     * 是的结案
     */
    @Excel(name = "是否结案")
    private String windCase;



    /**
     * 已发放数量
     */
    @Excel(name = "已发放数量")
    private BigDecimal grantNum;

    /**
     * 任务单ID
     */
    @Excel(name = "任务单ID")
    private Long taskId;

    /**
     * 派工记录ID
     */
    @Excel(name = "派工记录ID")
    private Long taskWorkunitId;


    /**
     * 预留相关需求的编号
     */
    @Excel(name = "预留相关需求的编号")
    private String requirementNumber;


    /**
     * 预留相关需求的项目编号
     */
    @Excel(name = "预留相关需求的项目编号")
    private String requirementProjectNumber;


    /**
     * 工单号
     */
    @Excel(name = "工单号")
    private String workorderCode;

    /**
     * 工单ID
     */
    @TableField(exist = false)
    private Long workorderId;
    /**
     * 申请数量
     */
    @Excel(name = "申请数量")
    private BigDecimal applyNum;

    private Integer applyType;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 工作单元id
     */
    private Long workunitId;

    /**
     * 工作单元编码
     */
    private String workunitCode;


    @TableField(exist = false)
    private String arrangeCode;

    /**
     * 工作单元名称
     */
    private String workunitName;

    /** 车间编码 */
    @Excel(name = "车间编码")
    private String workshopCode;
    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1")
    private String attr1;

    /**
     * 预留字段2
     */
    @Excel(name = "预留字段2")
    private String attr2;

    /**
     * 预留字段3
     */
    @Excel(name = "预留字段3")
    private Integer attr3;

    /**
     * 预留字段4
     */
    @Excel(name = "预留字段4")
    private Integer attr4;

    /**
     *是否倒冲
     */
    @TableField(exist = false)
    private String isBackflush;


    /** 物料信息 */
    @Excel(name = "物料信息")
    private List<ProAllocationItemList> itemList;

}
