package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdClientUrgeEmail;

/**
 * 催货款通知邮箱Service接口
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
public interface IMdClientUrgeEmailService
{
    /**
     * 查询催货款通知邮箱
     *
     * @param id 催货款通知邮箱主键
     * @return 催货款通知邮箱
     */
    public MdClientUrgeEmail selectMdClientUrgeEmailById(String id);

    /**
     * 查询催货款通知邮箱列表
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 催货款通知邮箱集合
     */
    public List<MdClientUrgeEmail> selectMdClientUrgeEmailList(MdClientUrgeEmail mdClientUrgeEmail);

    /**
     * 新增催货款通知邮箱
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 结果
     */
    public int insertMdClientUrgeEmail(MdClientUrgeEmail mdClientUrgeEmail);

    /**
     * 修改催货款通知邮箱
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 结果
     */
    public int updateMdClientUrgeEmail(MdClientUrgeEmail mdClientUrgeEmail);

    /**
     * 批量删除催货款通知邮箱
     *
     * @param ids 需要删除的催货款通知邮箱主键集合
     * @return 结果
     */
    public int deleteMdClientUrgeEmailByIds(String[] ids);

    /**
     * 删除催货款通知邮箱信息
     *
     * @param id 催货款通知邮箱主键
     * @return 结果
     */
    public int deleteMdClientUrgeEmailById(String id);
}
