package com.ximai.mes.qc.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.qc.domain.QcTemplateProcess;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 检测模板-工序Service接口
 *
 * @author generator
 * @date 2024-02-18
 */
public interface IQcTemplateProcessService {
    /**
     * 查询检测模板-工序
     *
     * @param recordId 检测模板-工序主键
     * @return 检测模板-工序
     */
    QcTemplateProcess selectQcTemplateProcessById(Long recordId);

    /**
     * 查询检测模板-工序列表
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 检测模板-工序集合
     */
    List<QcTemplateProcess> selectQcTemplateProcessList(QcTemplateProcess qcTemplateProcess);


    /**
     * 查询检测模板-工序列表
     *
     * @param query 检测模板-工序
     * @return 检测模板-工序集合
     */
    List<QcTemplateProcess> selectListJoinTemplateByQw(QueryWrapper<QcTemplateProcess> query);


    /**
     * 新增检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    int insertQcTemplateProcess(QcTemplateProcess qcTemplateProcess);

    /**
     * 修改检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    int updateQcTemplateProcess(QcTemplateProcess qcTemplateProcess);

    /**
     * 批量删除检测模板-工序
     *
     * @param recordIds 需要删除的检测模板-工序主键集合
     * @return 结果
     */
    int deleteQcTemplateProcessByIds(Long[] recordIds);

    /**
     * 删除检测模板-工序信息
     *
     * @param recordId 检测模板-工序主键
     * @return 结果
     */
    int deleteQcTemplateProcessById(Long recordId);

    void importExcel(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception;
}
