package com.ximai.mes.qc.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.qc.domain.QcAbnormalReport;
import com.ximai.mes.qc.service.IQcAbnormalReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 车间异常单Controller
 *
 * @author generator
 * @date 2024-02-20
 */
@RestController
@RequestMapping("/qc/report")
public class QcAbnormalReportController extends BaseController {
    @Autowired
    private IQcAbnormalReportService qcAbnormalReportService;

    /**
     * 查询车间异常单列表时间
     */

    @PreAuthorize("@ss.hasPermi('qc:report:list')")
    @GetMapping("/list")
    public TableDataInfo list(QcAbnormalReport qcAbnormalReport) {
        startPage();
        List<QcAbnormalReport> list = qcAbnormalReportService.selectQcAbnormalReportList(qcAbnormalReport);
        return getDataTable(list);
    }
    /**
     * 获取车间异常单详细信息
     */
    @PreAuthorize("@ss.hasPermi('qc:report:query')")
    @GetMapping(value = "/{abnormalReportId}")
    public AjaxResult getInfo(@PathVariable("abnormalReportId") Long abnormalReportId) {
        return AjaxResult.success(qcAbnormalReportService.selectQcAbnormalReportByAbnormalReportId(abnormalReportId));
    }

    /**
     * 新增车间异常单
     */
    @PreAuthorize("@ss.hasPermi('qc:report:add')")
    @Log(title = "车间异常单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody QcAbnormalReport qcAbnormalReport) {
        return toAjax(qcAbnormalReportService.insertObj(qcAbnormalReport));
    }

    /**
     * 修改车间异常单
     */
    @PreAuthorize("@ss.hasPermi('qc:report:edit')")
    @Log(title = "车间异常单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody QcAbnormalReport qcAbnormalReport) {
        return toAjax(qcAbnormalReportService.updateQcAbnormalReport(qcAbnormalReport));
    }

    /**
     * 删除车间异常单
     */
    @PreAuthorize("@ss.hasPermi('qc:report:remove')")
    @Log(title = "车间异常单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{abnormalReportIds}")
    public AjaxResult remove(@PathVariable Long[] abnormalReportIds) {
        return toAjax(qcAbnormalReportService.deleteQcAbnormalReportByAbnormalReportIds(abnormalReportIds));
    }

    /**
     * 完成按钮的功能实现
     */
    @PreAuthorize("@ss.hasPermi('qc:report:remove')")
    @Log(title = "车间异常单", businessType = BusinessType.DELETE)
    @PutMapping("/complete/{abnormalReportIds}")
    public AjaxResult putStatus(@PathVariable Long abnormalReportIds) {
        qcAbnormalReportService.updateQcAbnormalReportAbmornalStatud(abnormalReportIds);
        return AjaxResult.success("");
    }
}
