package com.ximai.mes.pro.service.impl;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.mapper.ProProductQrcodeRecordMapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRecord;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordDto;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;

/**
 * 产品序列号打印记录Service业务层处理
 *
 * @author generator
 * @date 2024-08-31
 */
@Service
public class ProProductQrcodeRecordServiceImpl implements IProProductQrcodeRecordService
{
    @Autowired
    private ProProductQrcodeRecordMapper proProductQrcodeRecordMapper;

    /**
     * 查询产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 产品序列号打印记录
     */
    @Override
    public ProProductQrcodeRecordDto selectProProductQrcodeRecordDtoByRecordId(Long recordId) {
        return proProductQrcodeRecordMapper.selectProProductQrcodeRecordByRecordId(recordId);
    }

    /**
     * 查询产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 产品序列号打印记录
     */
    @Override
    public ProProductQrcodeRecord selectProProductQrcodeRecordByRecordId(Long recordId) {
        return proProductQrcodeRecordMapper.selectById(recordId);
    }

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 产品序列号打印记录
     */
    @Override
    public List<ProProductQrcodeRecordDto> selectProProductQrcodeRecordList(ProProductQrcodeRecord proProductQrcodeRecord) {
        return proProductQrcodeRecordMapper.selectProProductQrcodeRecordList(proProductQrcodeRecord);
    }

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecordQuery 产品序列号打印记录
     * @return 产品序列号打印记录
     */
    @Override
    public List<ProProductQrcodeRecord> selectProProductQrcodeRecordList(QueryWrapper<ProProductQrcodeRecord> proProductQrcodeRecordQuery) {
        return proProductQrcodeRecordMapper.selectList(proProductQrcodeRecordQuery);
    }

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecordQuery 产品序列号打印记录
     * @return 产品序列号打印记录
     */
    @Override
    public List<ProProductQrcodeRecordDto> selectProProductQrcodeRecordDtoList(QueryWrapper<ProProductQrcodeRecord> proProductQrcodeRecordQuery) {
        return proProductQrcodeRecordMapper.selectDtoListByQw(proProductQrcodeRecordQuery);
    }

    /**
     * 新增产品序列号打印记录
     *
     * @param proProductQrcodeRecordCreate 产品序列号打印记录
     * @return 结果
     */
    @Override
    public int insertProProductQrcodeRecord(ProProductQrcodeRecordCreate proProductQrcodeRecordCreate) {
        proProductQrcodeRecordCreate.setPrintTime(0);
        ProProductQrcodeRecord proProductQrcodeRecord = new ProProductQrcodeRecord();
        BeanUtil.copyProperties(proProductQrcodeRecordCreate, proProductQrcodeRecord);
        proProductQrcodeRecord.setCreateBy(SecurityUtils.getUsername());
        proProductQrcodeRecord.setCreateTime(DateUtils.getNowDate());
        return proProductQrcodeRecordMapper.insertProProductQrcodeRecord(proProductQrcodeRecord);
    }

    /**
     * 修改产品序列号打印记录
     *
     * @param proProductQrcodeRecordUpdate 产品序列号打印记录
     * @return 结果
     */
    @Override
    public int updateProProductQrcodeRecord(ProProductQrcodeRecordUpdate proProductQrcodeRecordUpdate) {
        ProProductQrcodeRecord proProductQrcodeRecord = new ProProductQrcodeRecord();
        BeanUtil.copyProperties(proProductQrcodeRecordUpdate, proProductQrcodeRecord);
        proProductQrcodeRecord.setUpdateBy(SecurityUtils.getUsername());
        proProductQrcodeRecord.setUpdateTime(DateUtils.getNowDate());
        return proProductQrcodeRecordMapper.updateProProductQrcodeRecord(proProductQrcodeRecord);
    }

    /**
     * 批量删除产品序列号打印记录
     *
     * @param recordIds 需要删除的产品序列号打印记录主键
     * @return 结果
     */
    @Override
    public int deleteProProductQrcodeRecordByRecordIds(Long[] recordIds) {
        return proProductQrcodeRecordMapper.deleteProProductQrcodeRecordByRecordIds(recordIds);
    }

    /**
     * 删除产品序列号打印记录信息
     *
     * @param recordId 产品序列号打印记录主键
     * @return 结果
     */
    @Override
    public int deleteProProductQrcodeRecordByRecordId(Long recordId) {
        return proProductQrcodeRecordMapper.deleteProProductQrcodeRecordByRecordId(recordId);
    }
}
